/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.data.DataFactory;
import stream.data.TreeNode;
import stream.io.DataStream;
import stream.parser.DefaultTreeParser;

public class TreeStream
implements DataStream {
    static Logger log = LoggerFactory.getLogger(TreeStream.class);
    protected String treeAttribute = "tree";
    protected BufferedReader reader;
    protected DefaultTreeParser treeParser;
    protected Map<String, Class<?>> attributes = new LinkedHashMap();
    protected final List<Processor> processors = new ArrayList<Processor>();
    protected String id;

    public TreeStream(URL url) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(url.openStream()));
        this.treeParser = new DefaultTreeParser();
        this.attributes.put("tree", TreeNode.class);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getTreeAttribute() {
        return this.treeAttribute;
    }

    public void setTreeAttribute(String treeAttribute) {
        this.treeAttribute = treeAttribute;
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public Data readNext() throws Exception {
        return this.readNext(DataFactory.create());
    }

    @Override
    public Data readNext(Data datum) throws Exception {
        if (datum == null) {
            datum = DataFactory.create();
        }
        String line = this.reader.readLine();
        while (line != null && line.startsWith("#")) {
            line = this.reader.readLine();
        }
        if (line == null) {
            return null;
        }
        TreeNode tree = this.treeParser.parse(line);
        datum.put(this.treeAttribute, tree);
        return datum;
    }

    @Override
    public List<Processor> getPreprocessors() {
        return this.processors;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init() throws Exception {
    }
}

