/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import stream.AbstractProcessor;
import stream.Data;
import stream.data.TreeNode;
import stream.util.parser.ParseException;
import stream.util.parser.Parser;

public class DefaultTreeParser
extends AbstractProcessor
implements Parser<TreeNode> {
    int pos = 0;
    String data = "";
    String sourceKey = "sql";
    Map<String, String> defaults = new HashMap<String, String>();

    public DefaultTreeParser() {
        this("sql");
    }

    public DefaultTreeParser(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    @Override
    public TreeNode parse(String input) throws ParseException {
        this.data = input;
        this.pos = 0;
        try {
            return this.readTreeNode();
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    protected TreeNode readTreeNode() throws Exception {
        this.skip();
        this.read("(");
        String node = this.readToken(new char[]{'(', ')'});
        this.skip();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        while (this.startsWith("(")) {
            children.add(this.readTreeNode());
            this.skip();
        }
        this.skip();
        this.read(")");
        return new DefaultTreeNode(node, null, children);
    }

    @Override
    public Data process(Data data) {
        if (this.sourceKey != null && data.get(this.sourceKey) != null) {
            try {
                String source = ((Serializable)data.get(this.sourceKey)).toString();
                TreeNode tree = this.parse(source);
                if (tree != null) {
                    data.put("@tree", tree);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    protected String readToken() throws Exception {
        this.skip();
        StringBuffer tok = new StringBuffer();
        while (this.pos < this.data.length() && !Character.isWhitespace(this.data.charAt(this.pos))) {
            tok.append(this.data.charAt(this.pos++));
        }
        return tok.toString();
    }

    protected String readToken(char[] delimiters) throws Exception {
        this.skip();
        StringBuffer tok = new StringBuffer();
        while (this.pos < this.data.length() && !this.contains(delimiters, this.data.charAt(this.pos))) {
            tok.append(this.data.charAt(this.pos++));
        }
        return tok.toString();
    }

    protected boolean contains(char[] set, char ch) {
        for (char c : set) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    protected boolean startsWith(String start) {
        String remain = null;
        if (this.pos < this.data.length()) {
            remain = this.data.substring(this.pos);
        }
        return remain != null && remain.startsWith(start);
    }

    protected String read(String expected) throws Exception {
        if (this.data.substring(this.pos).startsWith(expected)) {
            this.pos += expected.length();
            return expected;
        }
        throw new Exception("Could not read '" + expected + "' from string: " + this.data.substring(this.pos));
    }

    protected int skip() {
        int skipped = 0;
        while (this.pos < this.data.length() && Character.isWhitespace(this.data.charAt(this.pos))) {
            ++this.pos;
            ++skipped;
        }
        return skipped;
    }

    public static void main(String[] args) throws Exception {
        String treeString = "( ROOT ( A1 ) ( A2 ) )";
        DefaultTreeParser parser = new DefaultTreeParser();
        TreeNode tree = parser.parse(treeString);
        System.out.println("the tree is: " + tree);
    }

    @Override
    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
        this.defaults = defaults;
    }

    public class DefaultTreeNode
    implements TreeNode {
        private static final long serialVersionUID = 5603730461142746019L;
        String label;
        TreeNode parent;
        Collection<TreeNode> children;

        public DefaultTreeNode(String label, TreeNode parent) {
            this(label, parent, new ArrayList<TreeNode>());
        }

        public DefaultTreeNode(String label, TreeNode parent, Collection<TreeNode> siblings) {
            this.label = label;
            this.parent = parent;
            this.children = siblings;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public boolean isLeaf() {
            return this.children == null || this.children.isEmpty();
        }

        @Override
        public Collection<TreeNode> children() {
            return this.children;
        }

        @Override
        public void addChild(TreeNode node) {
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>();
            }
            this.children.add(node);
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("( ");
            s.append(this.label);
            for (TreeNode ch : this.children()) {
                s.append(" ");
                s.append(ch.toString());
            }
            s.append(" )");
            return s.toString();
        }
    }
}

