/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ProcessContext;
import stream.runtime.ContainerContext;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class ProcessContextImpl
implements ProcessContext {
    static Logger log = LoggerFactory.getLogger(ProcessContextImpl.class);
    final ContainerContext containerContext;
    final Map<String, Object> context = new HashMap<String, Object>();

    public ProcessContextImpl() {
        this.containerContext = null;
    }

    public ProcessContextImpl(ContainerContext ctx) {
        this.containerContext = ctx;
        log.debug("Creating new ProcessContext, parent context is {}", (Object)ctx);
    }

    @Override
    public <T extends Service> T lookup(String ref, Class<T> serviceClass) throws Exception {
        if (this.containerContext == null) {
            throw new Exception("No parent context exists!");
        }
        return this.containerContext.lookup(ref, serviceClass);
    }

    public void register(String ref, Service p) throws Exception {
        if (this.containerContext == null) {
            throw new Exception("No parent context exists!");
        }
        this.containerContext.register(ref, p);
    }

    public void unregister(String ref) throws Exception {
        if (this.containerContext == null) {
            throw new Exception("No parent context exists!");
        }
        this.containerContext.unregister(ref);
    }

    public Map<String, ServiceInfo> list() throws Exception {
        return this.containerContext.list();
    }

    @Override
    public Object get(String key) {
        return this.context.get(key);
    }

    @Override
    public void set(String key, Object o) {
        this.context.put(key, o);
    }

    @Override
    public Object resolve(String variable) {
        if (!variable.startsWith("process.")) {
            if (this.containerContext == null) {
                return null;
            }
            return this.containerContext.resolve(variable);
        }
        return this.get(variable.substring("process.".length()));
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        throw new Exception("Addition of remote naming services is not supported by local context!");
    }
}

