/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.rpc.RemoteEndpoint;
import stream.util.MD5;

public class RMIServiceDelegator
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -6450480644005423871L;
    static Logger log = LoggerFactory.getLogger(RMIServiceDelegator.class);
    final RemoteEndpoint endpoint;

    public RMIServiceDelegator(RemoteEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("toString") && args == null) {
                return this.toString();
            }
            log.trace("received invoke-request, method: {}, args: {}", (Object)method.getName(), (Object)args);
            log.trace("   object reference is: {}", proxy);
            log.trace("   arg-types: {}", method.getParameterTypes());
            if (args != null && !(args.getClass().getComponentType() instanceof Serializable)) {
                log.error("Arguments are not serializable!");
            }
            ArrayList<Serializable> params = new ArrayList<Serializable>();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    params.add((Serializable)args[i]);
                }
            }
            log.trace("Calling endpoint {} with {}", (Object)this.endpoint, (Object)method);
            String signature = RMIServiceDelegator.computeSignature(method);
            Serializable result = method.getParameterTypes().length == 0 ? this.endpoint.call(method.getName(), signature, new ArrayList<Serializable>()) : this.endpoint.call(method.getName(), signature, params);
            return result;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String computeSignature(Method m) {
        StringBuffer s = new StringBuffer();
        s.append(m.getName() + "(");
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            s.append(types[i].toString());
            if (i + 1 >= types.length) continue;
            s.append(",");
        }
        s.append(")");
        log.trace("Method {} signature string is: {}", (Object)m, (Object)s);
        return MD5.md5(s.toString());
    }
}

