/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.rpc.RMIClient;
import stream.runtime.setup.ObjectFactory;

public class ContainerRefElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ContainerRefElementHandler.class);
    final ObjectFactory objectFactory;

    public ContainerRefElementHandler(ObjectFactory of) {
        this.objectFactory = of;
    }

    @Override
    public String getKey() {
        return "container-ref";
    }

    @Override
    public boolean handlesElement(Element element) {
        return this.getKey().equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element) throws Exception {
        String url;
        Map<String, String> attributes = this.objectFactory.getAttributes(element);
        String id = "" + attributes.get("id");
        if (attributes.containsKey("name")) {
            id = attributes.get("name");
        }
        if ((url = attributes.get("url")) != null) {
            URI uri = new URI(url);
            String proto = uri.getScheme();
            log.debug("  proto: {}", (Object)proto);
            log.debug("  host: {}", (Object)uri.getHost());
            log.debug("  port: {}", (Object)uri.getPort());
            if ("rmi".equalsIgnoreCase(proto)) {
                log.info("Adding remote RMI container connection...");
                RMIClient client = new RMIClient(uri.getHost(), new Integer(uri.getPort()));
                container.getContext().addContainer(id, client);
                return;
            }
            throw new Exception("Protocol '" + proto + "' not supported for remote containers!");
        }
        log.error("Missing attribute 'url' for element container-ref!");
        throw new Exception("Missing attribute 'url' for element container-ref!");
    }
}

