/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.Processor;
import stream.io.DataStream;
import stream.io.SourceURL;
import stream.io.multi.MultiDataStream;
import stream.runtime.ProcessContainer;
import stream.runtime.VariableContext;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ParameterInjection;
import stream.runtime.setup.ProcessorFactory;

public class DataStreamFactory {
    static Logger log = LoggerFactory.getLogger(DataStreamFactory.class);
    static final Map<String, String> streamClassesByExtension = new LinkedHashMap<String, String>();

    public static DataStream createStream(ObjectFactory objectFactory, ProcessorFactory processorFactory, Element node) throws Exception {
        DataStream stream;
        Constructor<?> constr;
        Map<String, String> params = objectFactory.getAttributes(node);
        Class<?> clazz = Class.forName(params.get("class"));
        String urlParam = params.get("url");
        if (urlParam == null || clazz == null) {
            // empty if block
        }
        if (urlParam != null) {
            constr = clazz.getConstructor(SourceURL.class);
            SourceURL url = null;
            String urlString = params.get("url");
            if ((urlString = objectFactory.expand(urlString)).startsWith("classpath:")) {
                String resource = urlParam.substring("classpath:".length());
                log.debug("Looking up resource '{}'", (Object)resource);
                URL u = ProcessContainer.class.getResource(resource);
                if (u == null) {
                    throw new Exception("Classpath url does not exist! Resource '" + resource + "' not found!");
                }
                url = new SourceURL(u);
            } else {
                url = new SourceURL(urlString);
            }
            stream = (DataStream)constr.newInstance(url);
        } else {
            constr = clazz.getConstructor(new Class[0]);
            stream = (DataStream)constr.newInstance(new Object[0]);
        }
        ArrayList<Processor> preProcessors = new ArrayList<Processor>();
        ParameterInjection.inject(stream, params, new VariableContext());
        if (stream instanceof MultiDataStream) {
            MultiDataStream multiStream = (MultiDataStream)stream;
            log.debug("Found a multi-stream, need to add inner streams...");
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node inner = nodes.item(i);
                if (inner.getNodeType() != 1) continue;
                Element child = (Element)inner;
                if (child.getNodeName().equalsIgnoreCase("stream") || child.getNodeName().equalsIgnoreCase("datastream")) {
                    DataStream innerStream = DataStreamFactory.createStream(objectFactory, processorFactory, child);
                    log.debug("Created inner stream {}", (Object)innerStream);
                    String id = child.getAttribute("id");
                    if (id == null || "".equals(id.trim())) {
                        id = innerStream.toString();
                    }
                    multiStream.addStream(id, innerStream);
                    continue;
                }
                log.debug("Creating pre-processors...");
                List<Processor> procs = processorFactory.createNestedProcessors(child);
                preProcessors.addAll(procs);
            }
            stream = multiStream;
        } else {
            List<Processor> procs = processorFactory.createNestedProcessors(node);
            preProcessors.addAll(procs);
        }
        for (Processor p : preProcessors) {
            stream.getPreprocessors().add(p);
        }
        return stream;
    }

    public static DataStream createStream(Map<String, String> params) throws Exception {
        Class<?> clazz = Class.forName(params.get("class"));
        Constructor<?> urlConstructor = null;
        try {
            urlConstructor = clazz.getConstructor(URL.class);
        }
        catch (Exception e) {
            log.error("Class {} does not provide an URL constructor...", (Object)clazz);
            urlConstructor = null;
        }
        DataStream stream = null;
        String urlParam = params.get("url");
        if (urlParam == null || urlConstructor == null) {
            if (urlParam == null) {
                log.debug("No 'url' parameter for data class {} found, checking for no-args constructor", (Object)clazz);
            } else {
                log.debug("No URL-constructor found for class {}, using no-args constructor...", (Object)clazz);
            }
            try {
                stream = (DataStream)clazz.newInstance();
                ParameterInjection.inject(stream, params, new VariableContext());
                stream.init();
                return stream;
            }
            catch (Exception e) {
                log.error("No no-args constructor found and no 'url' parameter specified for stream {}!", (Object)clazz);
                throw new Exception("No no-args constructor found and no 'url' parameter specified for stream " + clazz + "!");
            }
        }
        URL url = null;
        if (params.get("url").startsWith("classpath:")) {
            String resource = urlParam.substring("classpath:".length());
            log.debug("Looking up resource '{}'", (Object)resource);
            url = ProcessContainer.class.getResource(resource);
            if (url == null) {
                throw new Exception("Classpath url does not exist! Resource '" + resource + "' not found!");
            }
        } else {
            url = new URL(urlParam);
        }
        stream = (DataStream)urlConstructor.newInstance(url);
        stream.init();
        ParameterInjection.inject(stream, params, new VariableContext());
        if (stream instanceof MultiDataStream) {
            log.debug("Found a multi-stream, need to add inner streams...");
        }
        return stream;
    }

    public static Class<?> guessStreamFormat(String url) throws Exception {
        int idx;
        log.info("Trying to derive stream class from URL '{}'", (Object)url);
        String u = url.toLowerCase();
        boolean gz = u.endsWith(".gz");
        String ext = null;
        if (gz) {
            u = u.replaceAll("\\.gz$", "");
        }
        if ((idx = u.lastIndexOf(".")) > 0) {
            ext = u.substring(idx + 1);
            log.info("Extension of URL is '{}'", (Object)ext);
            String className = streamClassesByExtension.get(ext);
            if (className != null) {
                return Class.forName(className);
            }
        }
        return null;
    }

    static {
        streamClassesByExtension.put("csv", "stream.io.CsvStream");
        streamClassesByExtension.put("txt", "stream.io.LineStream");
        streamClassesByExtension.put("svmlight", "stream.io.SvmLightStream");
        streamClassesByExtension.put("json", "stream.io.JSONStream");
        streamClassesByExtension.put("arff", "stream.io.ArffStream");
    }
}

