/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.dependencies.Dependency;
import stream.runtime.dependencies.DependencyResolver;
import stream.runtime.setup.DocumentHandler;
import stream.runtime.setup.ObjectFactory;

public class LibrariesElementHandler
implements DocumentHandler,
ElementHandler {
    static Logger log = LoggerFactory.getLogger(LibrariesElementHandler.class);
    final ObjectFactory objectFactory;
    final DependencyResolver resolver = new DependencyResolver();

    public LibrariesElementHandler(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    @Override
    public String getKey() {
        return "LibsHandler";
    }

    @Override
    public boolean handlesElement(Element element) {
        return element.getNodeName().equalsIgnoreCase("libraries") || element.getNodeName().equalsIgnoreCase("libs");
    }

    @Override
    public void handleElement(ProcessContainer container, Element element) throws Exception {
        String text = element.getTextContent();
        if (text == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = reader.readLine();
        while (line != null) {
            String[] dep = line.trim().split(":");
            if (dep.length == 3) {
                Dependency d = new Dependency(dep[0], dep[1], dep[2]);
                try {
                    this.resolver.resolve(d);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            line = reader.readLine();
        }
        this.objectFactory.addClassPathUrls(this.resolver.getClasspathURLs());
    }

    @Override
    public void handle(ProcessContainer container, Document doc) throws Exception {
        log.debug("Checking for dependency definitions...");
        Set<Dependency> deps = this.findDependencies(doc.getDocumentElement());
        log.info("Found {} dependencies...", (Object)deps.size());
        for (Dependency dep : deps) {
            this.resolver.resolve(dep);
        }
        this.objectFactory.addClassPathUrls(this.resolver.getClasspathURLs());
    }

    public Set<Dependency> findDependencies(Element root) {
        LinkedHashSet<Dependency> deps = new LinkedHashSet<Dependency>();
        NodeList list = root.getElementsByTagName("dependency");
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            String groupId = null;
            String artifactId = null;
            String version = null;
            String scope = null;
            NodeList children = el.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeName().equals("groupId")) {
                    groupId = node.getTextContent();
                }
                if (node.getNodeName().equals("artifactId")) {
                    artifactId = node.getTextContent();
                }
                if (node.getNodeName().equals("version")) {
                    version = node.getTextContent();
                }
                if (!node.getNodeName().equals("scope")) continue;
                scope = node.getTextContent();
            }
            if (groupId == null || artifactId == null || version == null) continue;
            if (version.startsWith("[")) {
                version = version.substring(1);
            }
            if (version.endsWith(",)")) {
                version = version.replace(",)", "");
            }
            if (this.resolver.isScopeIncluded(scope)) {
                log.debug("Adding dependency {} with scope {}", (Object)artifactId, (Object)scope);
                deps.add(new Dependency(groupId, artifactId, version));
                continue;
            }
            log.debug("Dependencies with scope '{}' will be ignored.", (Object)scope);
        }
        return deps;
    }
}

