/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.Processor;
import stream.ProcessorList;
import stream.runtime.ElementHandler;
import stream.runtime.Process;
import stream.runtime.ProcessContainer;
import stream.runtime.ProcessContextImpl;
import stream.runtime.VariableContext;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;
import stream.runtime.setup.ServiceInjection;
import stream.runtime.setup.ServiceReference;
import stream.service.Service;

public class ProcessElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ProcessElementHandler.class);
    protected final ObjectFactory objectFactory;
    protected final ProcessorFactory processorFactory;

    public ProcessElementHandler(ObjectFactory objectFactory, ProcessorFactory processorFactory) {
        this.objectFactory = objectFactory;
        this.processorFactory = processorFactory;
    }

    @Override
    public String getKey() {
        return "Process";
    }

    @Override
    public boolean handlesElement(Element element) {
        return "process".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element) throws Exception {
        String id;
        Map<String, String> attr = this.objectFactory.getAttributes(element);
        String src = attr.get("source");
        if (src == null) {
            src = attr.get("input");
        }
        String out = attr.get("output");
        String processClass = "stream.runtime.Process";
        if (attr.containsKey("class")) {
            processClass = attr.get("class");
            log.info("Using custom process class '{}'", (Object)processClass);
        }
        if ((id = attr.get("id")) == null || "".equals(id.trim())) {
            id = "process";
        }
        String copies = attr.get("copies");
        if (attr.containsKey("multiply")) {
            copies = attr.get("multiply");
            log.warn("The attribute 'multiply' is deprecated for element 'Process'");
            log.warn("Please use 'copies' instead of 'multiply'.");
        }
        if (copies != null && !"".equals(copies.trim())) {
            String[] ids;
            VariableContext var = new VariableContext(container.getContext().getProperties());
            copies = var.expand(copies);
            if (copies.indexOf(",") >= 0) {
                ids = copies.split(",");
            } else {
                Integer times = new Integer(copies);
                ids = new String[times.intValue()];
                for (int i = 0; i < times; ++i) {
                    ids[i] = "" + i;
                }
            }
            for (String pid : ids) {
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("process.id", pid);
                extra.put("copy.id", pid);
                var.addVariables(extra);
                log.info("Creating process '{}'", (Object)pid);
                Process process = this.createProcess(processClass, attr, container, element, extra);
                String input = var.expand(src);
                log.info("Setting source for process {} to {}", (Object)process, (Object)input);
                process.setInput(input);
                if (out != null) {
                    String processOut = var.expand(out);
                    log.info("Setting process output for process {} to {}", (Object)process, (Object)processOut);
                    process.setOutput(processOut);
                } else {
                    log.info("Process has no output connection...");
                }
                container.getProcesses().add(process);
            }
        } else {
            this.objectFactory.set("process.id", id);
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("process.id", id);
            Process process = this.createProcess(processClass, attr, container, element, extra);
            log.debug("Created Process object: {}", (Object)process);
            container.getProcesses().add(process);
        }
    }

    protected Process createProcess(String processClass, Map<String, String> attr, ProcessContainer container, Element element, Map<String, String> extraVariables) throws Exception {
        Process process = (Process)this.objectFactory.create(processClass, attr, extraVariables);
        log.debug("Created Process object: {}", (Object)process);
        ProcessContextImpl ctx = new ProcessContextImpl(container.getContext());
        for (String key : attr.keySet()) {
            ctx.set(key, attr.get(key));
        }
        for (String key : extraVariables.keySet()) {
            ctx.set(key, extraVariables.get(key));
        }
        container.setProcessContext(process, ctx);
        List<Processor> procs = this.createNestedProcessors(container, element, extraVariables);
        for (Processor p : procs) {
            process.addProcessor(p);
            container.getDependencyGraph().add(process, p);
        }
        return process;
    }

    protected Processor createProcessor(ProcessContainer container, Element child, Map<String, String> extraVariables) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(child);
        Object o = this.objectFactory.create(child, extraVariables);
        if (o instanceof Processor) {
            HashMap<String, String> vars = new HashMap<String, String>(container.getContext().getProperties());
            vars.putAll(extraVariables);
            VariableContext vctx = new VariableContext(vars);
            if (o instanceof ProcessorList) {
                NodeList children = child.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    Processor proc = this.createProcessor(container, element, extraVariables);
                    if (proc != null) {
                        ((ProcessorList)o).getProcessors().add(proc);
                        continue;
                    }
                    log.warn("Nested element {} is not of type 'stream.data.Processor': ", (Object)node.getNodeName());
                }
            }
            if (params.containsKey("id") && !"".equals(params.get("id").trim())) {
                if (o instanceof Service) {
                    String id = params.get("id").trim();
                    id = vctx.expand(id);
                    log.debug("Registering processor with id '{}' in look-up service", (Object)id);
                    container.getContext().register(id, (Service)o);
                } else {
                    log.warn("Processor '{}' specifies an ID attribute '{}' but does not implement a Service interface. Processor will *not* be registered!", (Object)o.getClass().getName(), (Object)params.get("id"));
                }
            }
            Iterator<String> i$ = params.keySet().iterator();
            while (i$.hasNext()) {
                Class<? extends Service> serviceClass;
                String key;
                String k = key = i$.next();
                if (key.endsWith("-ref")) {
                    key = key.replace("-ref", "");
                }
                if ((serviceClass = ServiceInjection.hasServiceSetter(key, o)) == null) continue;
                log.info("Found service setter for key '{}' in processor {}", (Object)key, o);
                String ref = params.get(k);
                ref = vctx.expand(ref);
                ServiceReference serviceRef = new ServiceReference(ref, o, key, serviceClass);
                container.getServiceRefs().add(serviceRef);
            }
            return (Processor)o;
        }
        return null;
    }

    protected List<Processor> createNestedProcessors(ProcessContainer container, Element child, Map<String, String> extraVariables) throws Exception {
        ArrayList<Processor> procs = new ArrayList<Processor>();
        NodeList pnodes = child.getChildNodes();
        for (int j = 0; j < pnodes.getLength(); ++j) {
            Processor p;
            Node cnode = pnodes.item(j);
            if (cnode.getNodeType() != 1 || (p = this.createProcessor(container, (Element)cnode, extraVariables)) == null) continue;
            log.debug("Found processor...");
            procs.add(p);
        }
        return procs;
    }
}

