/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettings {
    static Logger log = LoggerFactory.getLogger(UserSettings.class);
    public static final String SETTINGS_FILE = "settings.properties";
    final Properties properties = this.findUserSettings();

    public File getStreamsDirectory() {
        return new File(System.getProperty("user.home") + File.separator + ".streams");
    }

    public List<URL> getLibrarySearchPath() {
        ArrayList<URL> paths = new ArrayList<URL>();
        try {
            paths.add(this.getStreamsDirectory().toURI().toURL());
            File streamsLib = this.getUserLocalFile("lib");
            paths.add(streamsLib.toURI().toURL());
        }
        catch (Exception e) {
            log.error("Failed to add URL to libary-search-path: {}", (Object)e.getMessage());
        }
        log.debug("User libary-search-paths: {}", (Object)paths);
        return paths;
    }

    public File getUserLocalFile(String name) {
        return new File(this.getStreamsDirectory().getAbsolutePath() + File.separator + name);
    }

    private Properties findUserSettings() {
        File file;
        Properties props = new Properties();
        File streamsDir = this.getStreamsDirectory();
        if (streamsDir.isDirectory() && (file = new File(streamsDir.getAbsolutePath() + File.separator + SETTINGS_FILE)).isFile()) {
            this.addProperties(file);
        }
        return props;
    }

    public void addProperties(File file) {
        block2: {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                this.properties.putAll((Map<?, ?>)props);
            }
            catch (Exception e) {
                log.error("Failed to add properties from file {}: {}", (Object)file, (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

