/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.shutdown;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.shutdown.DependencyGraph;
import stream.runtime.shutdown.ShutdownCondition;

public abstract class AbstractShutdownCondition
implements ShutdownCondition {
    static Logger log = LoggerFactory.getLogger(AbstractShutdownCondition.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCondition(DependencyGraph graph) {
        while (!this.isMet(graph)) {
            try {
                log.debug("shutdown-condition not met, waiting for changes in the dependency-graph...");
                DependencyGraph dependencyGraph = graph;
                synchronized (dependencyGraph) {
                    graph.wait();
                }
            }
            catch (Exception e) {
                log.error("Error while waiting for shutdown-condition: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) continue;
                e.printStackTrace();
            }
        }
    }
}

