/*
 * Decompiled with CFR 0.152.
 */
package stream.shell;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Shell;
import stream.runtime.DefaultNamingService;
import stream.service.Service;
import stream.shell.Command;

public class Call
extends Command {
    static Logger log = LoggerFactory.getLogger(Call.class);

    public Call(Shell shell) {
        super(shell);
    }

    @Override
    public String execute(String[] args) {
        if (args.length < 2) {
            return "Error: command 'call' requires at least name and method of the call!";
        }
        String name = args[0];
        String method = args[1];
        String[] params = new String[]{};
        if (args.length > 3) {
            params = new String[args.length - 3];
            for (int i = 0; i < params.length; ++i) {
                params[i] = args[i + 3];
            }
        }
        try {
            DefaultNamingService ns = this.shell.getNamingService();
            Service service = ns.lookup(name, Service.class);
            for (Class<?> intf : service.getClass().getInterfaces()) {
                this.println("[" + intf.getCanonicalName() + "]");
                for (Method m : intf.getMethods()) {
                    this.print("  -> public " + m.getReturnType() + " " + m.getName() + "(");
                    if (m.getName().equals(method)) {
                        Class<?>[] types = m.getParameterTypes();
                        Object[] arguments = new Object[types.length];
                        if (types.length == params.length) {
                            for (int i = 0; i < types.length; ++i) {
                                log.info("Creating argument of type {} from {}", (Object)types[i], (Object)params[i]);
                                Constructor<?> con = types[i].getConstructor(String.class);
                                arguments[i] = con.newInstance(params[i]);
                            }
                            log.debug("Invoking method {}", (Object)m);
                            Object value = m.invoke((Object)service, arguments);
                            this.println("RESULT: " + value);
                            return "";
                        }
                    }
                    if (m.getParameterTypes().length > 0) {
                        for (int i = 0; i < m.getParameterTypes().length; ++i) {
                            this.print(m.getParameterTypes()[i] + "");
                            if (i + 1 >= m.getParameterTypes().length) continue;
                            this.print(",");
                        }
                    }
                    this.println(")");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

