/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;
import stream.data.Statistics;
import stream.statistics.StatisticsService;

public abstract class StatisticsLearner
extends AbstractProcessor
implements StatisticsService {
    protected String[] keys;
    protected Statistics statistics = new Statistics();
    protected String prefix = "";

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=false, description="The keys/attributes this processor should account statistics (sum,average,min/max) for")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Parameter(required=false, description="An optional prefix that is prepended to the attribute names, which prevents the original attribute values from being overwritten by the respective sum/average/min/max value")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Data process(Data data) {
        this.updateStatistics(data);
        return data;
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(this.statistics);
    }

    public abstract void updateStatistics(Data var1);

    @Override
    public void reset() throws Exception {
        this.resetState();
    }

    @Override
    public void resetState() throws Exception {
        this.statistics = new Statistics();
    }
}

