/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import stream.Data;
import stream.StormRunner;
import stream.io.DataStream;
import stream.runtime.setup.DataStreamFactory;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;

public class StreamSpout
extends BaseRichSpout {
    private static final long serialVersionUID = -786482575770711600L;
    static Logger log = LoggerFactory.getLogger(StreamSpout.class);
    transient DataStream stream;
    protected SpoutOutputCollector output;
    protected final String xmlConfig;
    protected final String uuid;

    public StreamSpout(String xmlConfig, String uuid) {
        log.debug("Creating spout for stream {}", (Object)uuid);
        this.xmlConfig = xmlConfig;
        this.uuid = uuid;
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.output = collector;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document config = builder.parse(new ByteArrayInputStream(this.xmlConfig.getBytes()));
            Element element = StormRunner.findElementByUUID(config.getDocumentElement(), this.uuid);
            if (element == null) {
                throw new Exception("Damn! You screwed the XML!!");
            }
            ObjectFactory obf = ObjectFactory.newInstance();
            ProcessorFactory pf = new ProcessorFactory(obf);
            log.debug("Creating stream from element {}", (Object)element);
            this.stream = DataStreamFactory.createStream(obf, pf, element);
            this.stream.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to open stream: " + e.getMessage());
        }
    }

    public void nextTuple() {
        block3: {
            log.debug("nextTuple() called");
            try {
                Data item = this.stream.readNext();
                log.debug("read item: {}", (Object)item);
                if (item != null) {
                    log.debug("Emitting item as tuple...");
                    this.output.emit((List)new Values(new Object[]{item}));
                }
            }
            catch (Exception e) {
                log.error("Failed to read next item: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        log.debug("Declaring output-field 'stream.Data'");
        declarer.declare(new Fields(new String[]{"stream.Data"}));
    }
}

