/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.urls.TcpURLConnection;

public class TcpConnection {
    static Logger log = LoggerFactory.getLogger(TcpURLConnection.class);
    Socket connect;
    final String host;
    final Integer port;

    public TcpConnection(String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    public void connect() throws IOException {
        try {
            log.debug("Connecting via TCP to {}:{}", (Object)this.host, (Object)this.port);
            this.connect = new Socket(this.host, (int)this.port);
        }
        catch (IOException e) {
            log.error("Connection failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.connect == null) {
            this.connect();
        }
        if (this.connect == null) {
            log.error("Tried to access input-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnection not yet established!");
        }
        log.debug("Returning input-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connect == null || !this.connect.isConnected()) {
            log.error("Tried to access output-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnectio not yet established!");
        }
        log.debug("Returning output-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getOutputStream();
    }

    public String toString() {
        return "TcpConnection(" + super.toString() + ")[" + this.host + ":" + this.port + "]";
    }
}

