/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpURLConnection
extends URLConnection {
    static Logger log = LoggerFactory.getLogger(TcpURLConnection.class);
    Socket connect;

    protected TcpURLConnection(URL arg0) {
        super(arg0);
        log.debug("Creating TcpURLConnection for URL {}", (Object)arg0);
    }

    public TcpURLConnection() {
        super(null);
    }

    @Override
    public void connect() throws IOException {
        String host = this.url.getHost();
        Integer port = this.url.getPort();
        if (port == null) {
            port = 10001;
        }
        try {
            log.debug("Connecting via TCP to {}:{}", (Object)host, (Object)port);
            this.connect = new Socket(host, (int)port);
        }
        catch (IOException e) {
            log.error("Connection failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.connect == null) {
            this.connect();
        }
        if (this.connect == null) {
            log.error("Tried to access input-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnection not yet established!");
        }
        log.debug("Returning input-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.connect == null || !this.connect.isConnected()) {
            log.error("Tried to access output-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnectio not yet established!");
        }
        log.debug("Returning output-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getOutputStream();
    }
}

