/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CommandLineArgs {
    Map<String, String> options = new LinkedHashMap<String, String>();
    List<String> args = new ArrayList<String>();

    public CommandLineArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && i + 1 < args.length && !args[i + 1].startsWith("--")) {
                String key = this.getOptionName(args[i]);
                String value = args[i + 1];
                this.options.put(key, value);
                ++i;
                continue;
            }
            this.args.add(args[i]);
        }
    }

    public List<String> getArguments() {
        return this.args;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getOption(String key) {
        return this.getOption(key, null);
    }

    public String getOption(String key, String defaultValue) {
        if (this.options.get(key) == null) {
            return defaultValue;
        }
        return this.options.get(key);
    }

    protected String getOptionName(String opt) {
        String str = opt;
        while (str.startsWith("-")) {
            str = str.substring(1);
        }
        return str.replaceAll("-", "\\.");
    }

    public void setSystemProperties(String prefix) {
        String pre = prefix;
        if (!prefix.endsWith(".")) {
            pre = prefix + ".";
        }
        for (String opt : this.options.keySet()) {
            System.setProperty(pre + opt, this.options.get(opt));
        }
    }

    public void dumpArgs() {
        for (String opt : this.getOptions().keySet()) {
            System.out.println("  option " + opt + " = " + this.getOption(opt));
        }
        for (String arg : this.getArguments()) {
            System.out.println("  arg: " + arg);
        }
    }

    public static Properties expandSystemProperties(Properties p) {
        Properties result = new Properties();
        for (Object key : p.keySet()) {
            String k = key.toString();
            String value = p.getProperty(k);
            if (value.indexOf("${") >= 0) {
                for (Object o : System.getProperties().keySet()) {
                    String os = "${" + o.toString() + "}";
                    value = value.replace(os, System.getProperty(o.toString()));
                }
                result.setProperty(k, value);
                continue;
            }
            result.setProperty(k, p.getProperty(k));
        }
        return result;
    }

    public static void populateSystemProperties(Properties p) {
        for (Object k : p.keySet()) {
            if (System.getProperty(k.toString()) != null) continue;
            System.setProperty(k.toString(), p.getProperty(k.toString()));
        }
    }

    public static void main(String[] args) {
        String[] params = new String[]{"--limit", "120", "--block-size", "12", "--max-parts", "4", "/tmp/test.file", "/tmp/out-dir"};
        CommandLineArgs cla = new CommandLineArgs(params);
        cla.dumpArgs();
    }
}

