/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeParser {
    static Logger log = LoggerFactory.getLogger(TimeParser.class);
    static Map<String, Long> UNITS = new LinkedHashMap<String, Long>();
    public static final Long MILLISECOND = 1L;
    public static final Long SECOND = 1000L * MILLISECOND;
    public static final Long MINUTE = 60L * SECOND;
    public static final Long HOUR = 60L * MINUTE;
    public static final Long DAY = 24L * HOUR;
    public static final Long WEEK = 7L * DAY;
    public static final Long MONTH = 30L * DAY;
    public static final Long YEAR = 365L * DAY;

    public static Long parseTime(String str) throws Exception {
        long time = 0L;
        String s = str.trim();
        while (s.length() > 0) {
            String[] tok = TimeParser.readInteger(s);
            Integer i = new Integer(tok[0]);
            s = tok[1].trim();
            String unit = (tok = TimeParser.readUnit(s))[0];
            List<String> uk = TimeParser.findUnits(unit);
            if (uk.size() == 1) {
                unit = uk.get(0);
                log.debug("integer i = " + i + ",  unit = " + unit);
            } else {
                if (uk.isEmpty()) {
                    throw new Exception("Unknown time-unit '" + unit + "' found!");
                }
                if (uk.size() > 1) {
                    throw new Exception("Ambiguous time-unit '" + unit + "' found!");
                }
            }
            Long ms = UNITS.get(unit);
            time += (long)i.intValue() * ms;
            s = tok[1].trim();
        }
        return time;
    }

    public static String[] readInteger(String str) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < str.length() && TimeParser.isDigit(str, i)) {
            s.append(str.charAt(i++));
        }
        return new String[]{s.toString(), str.substring(i).trim()};
    }

    public static String[] readUnit(String str) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < str.length() & TimeParser.isUnitChar(str, i)) {
            s.append(str.charAt(i++));
        }
        return new String[]{s.toString(), str.substring(i)};
    }

    public static boolean isDigit(String str, int i) {
        if (i >= 0 && i < str.length()) {
            char ch = str.charAt(i);
            return Character.isDigit(ch);
        }
        return false;
    }

    public static boolean isUnitChar(String str, int i) {
        if (i >= 0 && i < str.length()) {
            char ch = str.charAt(i);
            return Character.isLetter(ch);
        }
        return false;
    }

    public static List<String> findUnits(String str) {
        LinkedList<String> units = new LinkedList<String>();
        for (String key : UNITS.keySet()) {
            if (!key.startsWith(str)) continue;
            units.add(key);
        }
        return units;
    }

    static {
        UNITS.put("ms", MILLISECOND);
        UNITS.put("years", YEAR);
        UNITS.put("months", MONTH);
        UNITS.put("weeks", WEEK);
        UNITS.put("days", DAY);
        UNITS.put("hours", HOUR);
        UNITS.put("minutes", MINUTE);
        UNITS.put("seconds", SECOND);
    }
}

