/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import stream.Command;
import stream.RunCommand;
import stream.doc.BuildIndex;
import stream.doc.SearchCommand;

public class Shell {
    static final Map<String, Command> commands = new LinkedHashMap<String, Command>();

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(Arrays.asList(args));
        String cmd = (String)params.remove(0);
        Command command = commands.get(cmd);
        if (command != null) {
            try {
                command.execute(params);
            }
            catch (Exception e) {
                System.err.println("Command failed: " + e.getMessage());
                System.exit(-1);
            }
        } else {
            System.err.println("Unknown command '" + cmd + "'.");
            System.exit(-1);
        }
    }

    static {
        commands.put("search", new SearchCommand());
        commands.put("build-index", new BuildIndex());
        commands.put("run", new RunCommand());
    }
}

