/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import stream.Data;
import stream.data.DataFactory;

public class DataArrayImpl
implements Data {
    private static final long serialVersionUID = -1633697890159204967L;
    protected int ext = 10;
    protected String[] keys = new String[10];
    protected Serializable[] values = new Serializable[10];
    int limit = 10;
    int size = 0;

    @Override
    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.limit = 0;
    }

    protected int indexOf(String key) {
        if (key == null) {
            return -1;
        }
        for (int i = 0; i < this.limit && i < this.keys.length; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key.toString()) > 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.limit && i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        LinkedHashSet<Map.Entry<String, Serializable>> entries = new LinkedHashSet<Map.Entry<String, Serializable>>();
        for (int i = 0; i < this.limit && i < this.keys.length; ++i) {
            entries.add(new Pair(this.keys[i], this.values[i]));
        }
        return entries;
    }

    @Override
    public Serializable get(Object key) {
        if (key == null) {
            return null;
        }
        int idx = this.indexOf(key.toString());
        if (idx >= 0 && idx < this.limit) {
            return this.values[idx];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.limit == 0;
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> ks = new LinkedHashSet<String>();
        for (int i = 0; i < this.limit && i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            ks.add(this.keys[i]);
        }
        return ks;
    }

    @Override
    public Serializable put(String key, Serializable value) {
        int idx = this.indexOf(key);
        if (idx >= 0) {
            this.values[idx] = value;
            return this.values[idx];
        }
        if (this.limit < this.keys.length) {
            this.keys[this.limit] = key;
            this.values[this.limit] = value;
            ++this.limit;
            ++this.size;
            return value;
        }
        String[] nk = new String[this.keys.length + this.ext];
        Serializable[] nv = new Serializable[this.keys.length + this.ext];
        for (int i = 0; i < this.limit; ++i) {
            nk[i] = this.keys[i];
            nv[i] = this.values[i];
        }
        nk[this.limit] = key;
        nv[this.limit] = value;
        ++this.limit;
        ++this.size;
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Serializable remove(Object key) {
        int idx = this.indexOf(key.toString());
        if (idx > 0) {
            this.keys[idx] = null;
            Serializable value = this.values[idx];
            this.values[idx] = null;
            --this.size;
            return value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<Serializable> values() {
        ArrayList<Serializable> vals = new ArrayList<Serializable>(this.size);
        for (int i = 0; i < this.limit && i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            vals.add(this.values[i]);
        }
        return vals;
    }

    @Override
    public Data createCopy() {
        return DataFactory.copy(this);
    }

    public final class Pair
    implements Map.Entry<String, Serializable>,
    Serializable {
        private static final long serialVersionUID = 6908846231903505137L;
        String key;
        Serializable value;

        public Pair(String key, Serializable value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Serializable getValue() {
            return this.value;
        }

        @Override
        public Serializable setValue(Serializable arg0) {
            this.value = arg0;
            return this.value;
        }
    }
}

