/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataImpl;
import stream.io.Serializer;
import stream.util.JavaSerializer;

public class DataFactory {
    static Logger log = LoggerFactory.getLogger(DataFactory.class);
    public static DataFactory defaultDataFactory = new DataFactory();
    private static long dataItemsCreated = 0L;
    final Serializer serializer = new JavaSerializer();

    protected DataFactory() {
    }

    public static void setDefaultDataFactory(DataFactory factory) throws Exception {
        if (dataItemsCreated > 0L) {
            throw new Exception("Data items have already been created with the current DataFactory '" + defaultDataFactory + "'. The DataFactory cannot be changed anymore!");
        }
        defaultDataFactory = factory;
    }

    public Data createDataItem() {
        return new DataImpl();
    }

    public Data clone(Data item) {
        try {
            return (Data)this.serializer.clone(item);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Data createDataItem(Map<String, Serializable> item) {
        return new DataImpl(item);
    }

    public static Data create() {
        ++dataItemsCreated;
        return defaultDataFactory.createDataItem();
    }

    public static Data copy(Data item) {
        return defaultDataFactory.clone(item);
    }

    public static Data create(Map<String, Serializable> data) {
        ++dataItemsCreated;
        return defaultDataFactory.createDataItem(data);
    }

    public static long getDataItemsCreated() {
        return dataItemsCreated;
    }
}

