/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import stream.Data;
import stream.Measurable;
import stream.data.DataFactory;
import stream.util.JavaSerializer;
import stream.util.SizeOf;

public class DataImpl
extends LinkedHashMap<String, Serializable>
implements Data,
Measurable {
    private static final long serialVersionUID = -7751681008628413236L;
    static final boolean deepClone = "true".equalsIgnoreCase(System.getProperty("stream.Data.deepClone"));
    final transient JavaSerializer javaSerializer = new JavaSerializer();

    protected DataImpl() {
    }

    public DataImpl(Map<String, Serializable> data) {
        super(data);
    }

    @Override
    public double getByteSize() {
        double size = 0.0;
        for (String key : this.keySet()) {
            size += (double)(key.length() + 1);
            Serializable value = (Serializable)this.get(key);
            size += SizeOf.sizeOf((Object)value);
        }
        return size;
    }

    @Override
    public Data createCopy() {
        if (this == Data.END_OF_STREAM) {
            return Data.END_OF_STREAM;
        }
        if (!deepClone) {
            return new DataImpl(this);
        }
        return DataFactory.copy(this);
    }
}

