/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Statistics
extends LinkedHashMap<String, Double> {
    private static final long serialVersionUID = 5994452860264445162L;
    String name = "";
    String key = "";

    public Statistics() {
    }

    public Statistics(String name) {
        this.name = name;
    }

    public Statistics(Statistics stats) {
        this(stats.getName());
        this.add(stats);
    }

    public String getName() {
        return this.name;
    }

    public Statistics setName(String name) {
        this.name = name;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Statistics setKey(String key) {
        this.key = key;
        return this;
    }

    public synchronized void add(Map<String, Double> st) {
        for (String key : st.keySet()) {
            Double d = (Double)this.get(key);
            d = d == null ? st.get(key) : Double.valueOf(d + st.get(key));
            this.put(key, d);
        }
    }

    public synchronized void add(Statistics st) {
        for (String key : st.keySet()) {
            Double d = (Double)this.get(key);
            d = d == null ? (Double)st.get(key) : Double.valueOf(d + (Double)st.get(key));
            this.put(key, d);
        }
    }

    public synchronized void substract(Map<String, Double> st) {
        for (String key : st.keySet()) {
            Double d = (Double)this.get(key);
            d = d == null ? Double.valueOf(-st.get(key).doubleValue()) : Double.valueOf(d - st.get(key));
            this.put(key, d);
        }
    }

    public synchronized void max(Map<String, Double> st) {
        LinkedList keys = new LinkedList(this.keySet());
        for (String k : st.keySet()) {
            if (keys.contains(k)) continue;
            keys.add(k);
        }
        for (String key : keys) {
            this.put(key, this.max((Double)this.get(key), st.get(key)));
        }
    }

    protected Double max(Double d1, Double d2) {
        if (d1 == null && d2 == null) {
            return Double.NaN;
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return Math.max(d1, d2);
    }

    public Statistics divideBy(String key) {
        Statistics st = new Statistics();
        st.putAll(this);
        Double x = (Double)this.get(key);
        if (x == null || x == 0.0) {
            return st;
        }
        for (String k : this.keySet()) {
            if (k.equals(key)) continue;
            Double val = (Double)this.get(k);
            st.put(k, val / x);
        }
        return st;
    }

    public Statistics divideBy(Double val) {
        Statistics st = new Statistics();
        for (String k : this.keySet()) {
            st.put(k, (Double)this.get(k) / val);
        }
        return st;
    }

    public void add(String key, Double val) {
        if (this.containsKey(key)) {
            Double d = (Double)this.get(key) + val;
            this.put(key, d);
        } else {
            this.put(key, val);
        }
    }
}

