/*
 * Decompiled with CFR 0.152.
 */
package stream.doc;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Internal;
import stream.doc.ClassFinder;
import stream.io.Stream;

public class DocFinder {
    static Logger log = LoggerFactory.getLogger(DocFinder.class);
    public static final Class<?>[] CLASSES = new Class[]{Processor.class, Stream.class};

    public static boolean matches(String[] patterns, Class<?> clazz) {
        if (patterns == null || patterns.length == 0) {
            return true;
        }
        try {
            String className = clazz.getCanonicalName();
            if (className == null) {
                return false;
            }
            log.info("ClassName is: {}", (Object)className);
            for (String pattern : patterns) {
                if (!className.startsWith(pattern)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean implementsInterface(Class<?> clazz, Class<?> intf) {
        return intf.isAssignableFrom(clazz);
    }

    public static void main(String[] args) throws Exception {
        Class<?>[] classes = ClassFinder.getClasses("");
        TreeSet<String> docs = new TreeSet<String>();
        TreeSet<String> missing = new TreeSet<String>();
        block0: for (Class<?> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            if (clazz.isAnnotationPresent(Internal.class)) {
                System.out.println("Skipping internal class " + clazz);
                continue;
            }
            for (Class<?> apiClass : CLASSES) {
                if (!apiClass.isAssignableFrom(clazz)) continue;
                if (!DocFinder.matches(args, clazz)) {
                    log.info("Skipping class {}", (Object)clazz);
                    continue;
                }
                if (clazz.isAnnotationPresent(Deprecated.class)) {
                    System.out.println("Skipping deprecated class " + clazz);
                    continue block0;
                }
                log.debug("Found processor-class {}", (Object)clazz);
                log.debug("    clazz.getName() = {}", (Object)clazz.getName());
                String doc = "/" + clazz.getName().replace('.', '/') + ".md";
                log.debug("    docs are at {}", (Object)doc);
                URL url = DocFinder.class.getResource(doc);
                if (url != null) {
                    docs.add(doc);
                    continue;
                }
                missing.add(doc);
                log.error("No documentation provided for class {}", (Object)clazz);
            }
        }
        for (String doc : docs) {
            System.out.println("   " + doc);
        }
        System.out.println("");
        System.out.println("Missing documentation:");
        for (String doc : missing) {
            System.out.println("   " + doc);
        }
        Integer total = missing.size() + docs.size();
        Integer complete = docs.size();
        DecimalFormat fmt = new DecimalFormat("0.00%");
        System.out.println("Documentation completness is " + fmt.format(complete.doubleValue() / total.doubleValue()));
    }

    public static Map<Class<?>, URL> findDocumentations(String[] packages) throws Exception {
        LinkedHashMap docTexts = new LinkedHashMap();
        Class<?>[] classes = ClassFinder.getClasses("");
        TreeSet<String> docs = new TreeSet<String>();
        TreeSet<String> missing = new TreeSet<String>();
        block0: for (Class<?> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || clazz.isAnnotationPresent(Internal.class)) continue;
            for (Class<?> apiClass : CLASSES) {
                if (!apiClass.isAssignableFrom(clazz)) continue;
                if (!DocFinder.matches(packages, clazz)) {
                    log.info("Skipping class {}", (Object)clazz);
                    continue;
                }
                if (clazz.isAnnotationPresent(Deprecated.class)) {
                    System.out.println("Skipping deprecated class " + clazz);
                    continue block0;
                }
                log.debug("Found processor-class {}", (Object)clazz);
                log.debug("    clazz.getName() = {}", (Object)clazz.getName());
                String doc = "/" + clazz.getName().replace('.', '/') + ".md";
                log.debug("    docs are at {}", (Object)doc);
                URL url = DocFinder.class.getResource(doc);
                String tex = "/" + clazz.getName().replace('.', '/') + ".tex";
                URL texUrl = DocFinder.class.getResource(tex);
                if (texUrl != null) {
                    url = texUrl;
                }
                if (url != null) {
                    docs.add(doc);
                    docTexts.put(clazz, url);
                    continue;
                }
                missing.add(doc);
                log.error("No documentation provided for class {}", (Object)clazz);
            }
        }
        return docTexts;
    }
}

