/*
 * Decompiled with CFR 0.152.
 */
package stream.doc.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.doc.DocFinder;
import stream.util.URLUtilities;

public class DocIndex
implements Serializable {
    private static final long serialVersionUID = 6874000860509328529L;
    static Logger log = LoggerFactory.getLogger(DocIndex.class);
    Map<Data, URL> docs = new HashMap<Data, URL>();

    public static DocIndex getInstance() {
        File userIndex = new File(System.getProperty("user.home") + File.separator + ".streams.doc");
        if (userIndex.canRead()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(userIndex));
                DocIndex idx = (DocIndex)ois.readObject();
                ois.close();
                return idx;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DocIndex index = new DocIndex();
        try {
            Map<Class<?>, URL> help = DocFinder.findDocumentations(null);
            for (Class<?> clazz : help.keySet()) {
                URL url = help.get(clazz);
                String text = URLUtilities.readContentOrEmpty(url);
                log.debug("Adding text:\n-----------------\n{}\n--------------------\n", (Object)text);
                index.add(text, url, clazz);
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(userIndex));
            oos.writeObject(index);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return index;
    }

    private Data createWordVector(String text) {
        String[] words;
        Data item = DataFactory.create();
        for (String w : words = text.split("\\W+")) {
            String word = w.trim();
            if (word.isEmpty()) continue;
            Double count = (Double)item.get(word);
            if (count == null) {
                count = 0.0;
            }
            count = count + 1.0;
            item.put(word, count);
        }
        return item;
    }

    public void add(String text, URL location, Class<?> clazz) {
        log.debug("Adding document {}", (Object)location);
        Data wv = this.createWordVector(text.toLowerCase());
        if (clazz != null) {
            wv.put("@class", clazz.getCanonicalName());
        }
        log.debug("Adding text:\n-----------------\n{}\n--------------------\n", (Object)text);
        this.docs.put(wv, location);
    }

    public List<Result> search(String query) {
        ArrayList<Result> results = new ArrayList<Result>();
        Data qv = this.createWordVector(query.toLowerCase());
        for (Data wv : this.docs.keySet()) {
            double score = this.dist(qv, wv);
            if (!(score > 0.0)) continue;
            results.add(new Result(this.docs.get(wv), score, wv.get("@class") + ""));
        }
        Collections.sort(results);
        return results;
    }

    public Double dist(Data w, Data v) {
        HashSet keys = new HashSet();
        keys.addAll(w.keySet());
        keys.addAll(v.keySet());
        double val = 0.0;
        for (String k : keys) {
            Double v1;
            Double w1;
            if (k.startsWith("@") || (w1 = (Double)w.get(k)) == null || (v1 = (Double)v.get(k)) == null) continue;
            val += w1 * v1;
        }
        return val;
    }

    public class Result
    implements Comparable<Result>,
    Serializable {
        private static final long serialVersionUID = -1224420400062085703L;
        public final URL url;
        public final Double score;
        public final String className;

        public Result(URL url, Double score, String className) {
            this.url = url;
            this.score = score;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public int compareTo(Result arg0) {
            int ret = this.score.compareTo(arg0.score);
            if (ret == 0) {
                return this.url.toString().compareTo(arg0.toString());
            }
            return -ret;
        }
    }
}

