/*
 * Decompiled with CFR 0.152.
 */
package stream.doc.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.runtime.setup.ParameterDiscovery;
import stream.service.Service;

public class ParameterTableCreator {
    static Logger log = LoggerFactory.getLogger(ParameterTableCreator.class);

    public static List<ParameterInfo> getParameterInfos(Class<?> clazz) {
        ArrayList<ParameterInfo> infos = new ArrayList<ParameterInfo>();
        Map<String, Class<?>> types = ParameterDiscovery.discoverParameters(clazz);
        for (String key : types.keySet()) {
            Parameter p = ParameterDiscovery.getParameterAnnotation(clazz, key);
            if (p == null) continue;
            Class<?> type = ParameterDiscovery.getParameterType(clazz, key);
            infos.add(new ParameterInfo(p, type));
        }
        for (Method m : clazz.getMethods()) {
            Class<?> argType;
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Service.class.isAssignableFrom(argType = m.getParameterTypes()[0])) continue;
            log.info("Found service-setter!");
            infos.add(new ParameterInfo(m.getName().substring(3).toLowerCase() + "-ref", argType, ""));
        }
        return infos;
    }

    public static void main(String[] args) {
        List<ParameterInfo> infos = ParameterTableCreator.getParameterInfos(Service.class);
        for (ParameterInfo info : infos) {
            System.out.println(info.name);
        }
    }

    public static class ParameterInfo {
        final String name;
        final Class<?> type;
        final String description;
        final boolean required;
        final Double min;
        final Double max;
        final String defaultValue;

        public ParameterInfo(Parameter p, Class<?> cl) {
            this.name = p.name();
            this.type = cl;
            this.defaultValue = p.defaultValue();
            this.description = p.description();
            this.min = p.min();
            this.max = p.max();
            this.required = p.required();
        }

        public ParameterInfo(String name, Class<?> type, String desc) {
            this.name = name;
            this.type = type;
            this.description = desc;
            this.min = null;
            this.max = null;
            this.required = true;
            this.defaultValue = "";
        }
    }
}

