/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stream.expressions.BinaryOperator;
import stream.expressions.ConditionPM;
import stream.expressions.ExpressionException;
import stream.util.WildcardPattern;

public abstract class Operator
implements Serializable {
    private static final long serialVersionUID = 5150175070404610787L;
    public static final Operator EQ = new BinaryOperator("@eq", new String[]{"=", "=="}){
        private static final long serialVersionUID = -7185932909087120854L;

        @Override
        public boolean eval(Object left, Object right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null && right != null) {
                return right.toString().equals("null");
            }
            if (left != null && right == null) {
                return left.toString().equals("null");
            }
            if (this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    Double v = new Double(left.toString());
                    Double w = new Double(right.toString());
                    int rc = v.compareTo(w);
                    return rc == 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return left.equals(right);
        }
    };
    public static final Operator NEQ = new BinaryOperator("@neq", new String[]{"!=", "<>"}){
        private static final long serialVersionUID = -7185932909087120854L;

        @Override
        public boolean eval(Object left, Object right) {
            if (left == null && right == null) {
                return false;
            }
            if (left != null && right != null && this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    Double v = new Double(left.toString());
                    Double w = new Double(right.toString());
                    int rc = v.compareTo(w);
                    return rc != 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return !("" + left).equals("" + right);
        }
    };
    public static final Operator LT = new BinaryOperator("@lt", new String[]{"<"}){
        private static final long serialVersionUID = 7290798880449531730L;

        @Override
        public boolean eval(Object left, Object right) {
            if (this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    Double v = new Double(left.toString());
                    Double w = new Double(right.toString());
                    int rc = v.compareTo(w);
                    return rc < 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ("" + left).compareTo("" + right) < 0;
        }
    };
    public static final Operator LE = new BinaryOperator("@le", new String[]{"<=", "=<"}){
        private static final long serialVersionUID = -6196215282881485160L;

        @Override
        public boolean eval(Object left, Object right) {
            if (this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    return new Double(left.toString()).compareTo(new Double(right.toString())) <= 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ("" + left).compareTo("" + right) <= 0;
        }
    };
    public static final Operator GT = new BinaryOperator("@gt", new String[]{">"}){
        private static final long serialVersionUID = 5904824908737265272L;

        @Override
        public boolean eval(Object left, Object right) {
            if (this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    Double v = new Double(left.toString());
                    Double w = new Double(right.toString());
                    int rc = v.compareTo(w);
                    return rc > 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ("" + left).compareTo("" + right) > 0;
        }
    };
    public static final Operator GE = new BinaryOperator("@ge", new String[]{">=", "=>"}){
        private static final long serialVersionUID = -1267321837098130076L;

        @Override
        public boolean eval(Object left, Object right) {
            if (this.isNumeric(left) && this.isNumeric(right)) {
                try {
                    return new Double(left.toString()).compareTo(new Double(right.toString())) >= 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ("" + left).compareTo("" + right) >= 0;
        }
    };
    public static final Operator PM = new ConditionPM();
    public static final Operator RX = new BinaryOperator("@rx", new String[]{"~"}){
        private static final long serialVersionUID = -2886662198464559265L;

        @Override
        public boolean eval(Object left, Object right) {
            if (right != null && right instanceof String) {
                Pattern pattern = Pattern.compile(right.toString());
                Matcher m = pattern.matcher(left + "");
                return m.matches();
            }
            return false;
        }
    };
    public static final Operator NRX = new BinaryOperator("@nrx", new String[]{"!~"}){
        private static final long serialVersionUID = -2886662198464559265L;

        @Override
        public boolean eval(Object left, Object right) {
            if (right != null && right instanceof String) {
                Pattern pattern = Pattern.compile(right.toString());
                Matcher m = pattern.matcher(left + "");
                return !m.matches();
            }
            return false;
        }
    };
    public static final Operator SX = new BinaryOperator("@sx"){
        private static final long serialVersionUID = 7929480963946320536L;

        @Override
        public boolean eval(Object left, Object right) {
            WildcardPattern pattern = new WildcardPattern("" + left);
            return pattern.matches("" + right);
        }
    };
    public static final Map<String, Operator> OPERATORS = new LinkedHashMap<String, Operator>();
    private final String name;
    private final String[] aliases;

    public static final void registerOperator(Operator op) {
        OPERATORS.put(op.name, op);
        OPERATORS.put("!" + op.name, op);
        for (String alias : op.getAliases()) {
            Operator.registerAlias(op, alias);
        }
    }

    public static final void registerAlias(Operator op, String alias) {
        if (OPERATORS.get(op.name) != null) {
            OPERATORS.put(alias, OPERATORS.get(op.name));
        }
    }

    public Operator(String str) {
        this(str, new String[0]);
    }

    public Operator(String str, String[] aliases) {
        this.name = str;
        this.aliases = aliases;
    }

    public boolean isNegated() {
        return this.name.startsWith("!");
    }

    public String toString() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static Operator read(String str) throws ExpressionException {
        for (String key : OPERATORS.keySet()) {
            if (!key.equals(str)) continue;
            return OPERATORS.get(key);
        }
        for (Operator op : OPERATORS.values()) {
            if (!op.name.equals(str)) continue;
            return op;
        }
        throw new ExpressionException("Invalid operator name: '" + str + "'!");
    }

    static {
        Operator.registerOperator(NEQ);
        Operator.registerOperator(EQ);
        Operator.registerOperator(LT);
        Operator.registerOperator(LE);
        Operator.registerOperator(GT);
        Operator.registerOperator(GE);
        Operator.registerOperator(PM);
        Operator.registerOperator(RX);
        Operator.registerOperator(NRX);
        Operator.registerOperator(SX);
    }
}

