/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.data.DataFactory;
import stream.io.QueueService;

public class Dequeue
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Dequeue.class);
    QueueService queue;

    public QueueService getQueue() {
        return this.queue;
    }

    public void setQueue(QueueService queue) {
        this.queue = queue;
    }

    @Override
    public Data process(Data input) {
        if (this.queue != null) {
            Data item;
            if (input == null) {
                input = DataFactory.create();
            }
            if ((item = this.queue.take()) != null) {
                log.debug("Merging dequeued item '{}'", (Object)item);
                input.putAll(item);
            } else {
                log.error("Dequeued 'null' from queue - unexpected?!");
            }
        } else {
            log.debug("No queue defined, not dequeuing anything...");
        }
        return input;
    }
}

