/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessorList;
import stream.annotations.Parameter;

public class ForEach
extends ProcessorList {
    static Logger log = LoggerFactory.getLogger(ForEach.class);
    String key;

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The name of the attribute containing the collection of items that should be processed.")
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Data process(Data input) {
        if (this.key == null) {
            return input;
        }
        Serializable value = (Serializable)input.get(this.key);
        if (value == null) {
            return input;
        }
        ArrayList<Data> incol = new ArrayList<Data>();
        if (value instanceof Collection) {
            for (Data item : (Collection)((Object)value)) {
                incol.add(item);
            }
        } else if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Data item = (Data)Array.get(value, i);
                if (item == null) continue;
                incol.add(item);
            }
        } else {
            log.debug("Collection of type {} not supported!", (Object)value.getClass());
        }
        ArrayList<Data> outcol = new ArrayList<Data>();
        for (Data item : incol) {
            if ((item = super.process(item)) == null) continue;
            outcol.add(item);
        }
        input.put(this.key, outcol.toArray(new Data[outcol.size()]));
        return input;
    }
}

