/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.expressions.Condition;
import stream.flow.AbstractSplit;
import stream.io.Sink;

public class SplitByCondition
extends AbstractSplit {
    static Logger log = LoggerFactory.getLogger(SplitByCondition.class);
    final List<RoutingEntry> routes = new ArrayList<RoutingEntry>();
    final Context ctx = new SplitContext();
    boolean multiply = false;

    @Override
    public List<Condition> getConditions() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (RoutingEntry re : this.routes) {
            conditions.add(re.condition);
        }
        return Collections.unmodifiableList(conditions);
    }

    @Override
    public void add(Condition condition, Sink sink) {
        this.routes.add(new RoutingEntry(condition, sink));
    }

    @Override
    public void write(Data item) throws Exception {
        for (RoutingEntry entry : this.routes) {
            if (entry.condition != null && !entry.condition.matches(this.ctx, item)) continue;
            log.debug("Sending item to sink {}", (Object)entry.sink);
            entry.sink.write(item);
            if (this.multiply) continue;
            log.debug("non-multiplying split, doing first-match-delivery");
            return;
        }
        log.warn("No data-flow matching item {} in split {}. Item will be discarded!", (Object)item, (Object)this.id);
    }

    public class SplitContext
    implements Context {
        @Override
        public Object resolve(String variable) {
            return null;
        }
    }

    public class RoutingEntry {
        public final Condition condition;
        public final Sink sink;

        public RoutingEntry(Condition c, Sink s) {
            this.condition = c;
            this.sink = s;
        }
    }
}

