/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.expressions.Condition;
import stream.flow.AbstractSplit;
import stream.io.Sink;

public class SplitByRandom
extends AbstractSplit {
    static Logger log = LoggerFactory.getLogger(SplitByRandom.class);
    protected final ArrayList<Sink> sinks = new ArrayList();
    protected final Random random = new Random();

    @Override
    public void write(Data item) throws Exception {
        int idx = this.random.nextInt(this.sinks.size());
        Sink sink = this.sinks.get(idx);
        if (sink != null) {
            log.debug("Sending item to sink {}", (Object)sink.getId());
            sink.write(item);
        } else {
            log.error("No sink found for index '{}'", (Object)idx);
        }
    }

    @Override
    public List<Condition> getConditions() {
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public void add(Condition condition, Sink sink) {
        this.sinks.add(sink);
    }
}

