/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.SourceURL;
import stream.io.Stream;

public abstract class AbstractStream
implements Stream {
    static Logger log = LoggerFactory.getLogger(AbstractStream.class);
    protected SourceURL url;
    protected Long limit = -1L;
    protected Long count = 0L;
    protected String prefix = null;
    protected String id;
    protected InputStream in;

    public AbstractStream(SourceURL url) {
        this.url = url;
    }

    public AbstractStream(InputStream in) {
        this.in = in;
    }

    protected AbstractStream() {
        this.url = null;
    }

    protected InputStream getInputStream() throws Exception {
        if (this.in == null) {
            this.in = this.url.openStream();
        }
        return this.in;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Parameter(required=true, description="The ID of this stream for associating it with processes.")
    public void setId(String id) {
        this.id = id;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Parameter(required=false, description="An optional prefix string to prepend to all attribute names.", defaultValue="")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    @Parameter(required=false, description="The maximum number of items that this stream should deliver.", defaultValue="-1", max=9.223372036854776E18)
    public void setLimit(Long limit) {
        this.limit = limit;
    }

    @Override
    public Data read() throws Exception {
        if (this.limit > 0L && this.count >= this.limit) {
            return null;
        }
        Data datum = null;
        while (datum == null) {
            datum = this.readNext();
            if (datum == null) {
                log.debug("End-of-stream reached!");
                return null;
            }
            if (this.id != null) {
                datum.put("@stream", this.id);
            }
            if (this.prefix == null || this.prefix.trim().isEmpty()) continue;
            Data prefixed = DataFactory.create();
            for (String key : datum.keySet()) {
                prefixed.put(this.prefix + ":" + key, datum.get(key));
            }
            datum = prefixed;
        }
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        return datum;
    }

    public abstract Data readNext() throws Exception;

    @Override
    public void init() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }
}

