/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractLineStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class ArffStream
extends AbstractLineStream {
    static Logger log = LoggerFactory.getLogger(ArffStream.class);

    public ArffStream(SourceURL url) throws Exception {
        super(url);
    }

    public void readHeader() throws Exception {
        String line = this.readLine();
        while (line != null && !line.startsWith("@data")) {
            if (line.startsWith("@attribute")) {
                String[] tok = line.split("\\s");
                Class<Object> clazz = Object.class;
                if ("numeric".equalsIgnoreCase(tok[2].trim())) {
                    clazz = Double.class;
                }
                String app = "";
                int i = 0;
                while (this.attributes.containsKey(tok[1] + app)) {
                    app = "_" + i++;
                }
                this.attributes.put(tok[1] + app, clazz);
            }
            line = this.readLine();
        }
        log.info("Attributes of Arff-Stream: {}", (Object)this.attributes);
    }

    @Override
    public Data readNext() throws Exception {
        Data datum = DataFactory.create();
        String line = this.readLine();
        while (line != null && line.trim().isEmpty()) {
            line = this.readLine();
        }
        if (line != null && !line.trim().equals("")) {
            String[] tok = line.split(",");
            int i = 0;
            for (String name : this.attributes.keySet()) {
                if (i >= tok.length) break;
                if (Double.class.equals(this.attributes.get(name))) {
                    datum.put(name, new Double(tok[i]));
                } else {
                    datum.put(name, tok[i]);
                }
                ++i;
            }
        }
        return datum;
    }
}

