/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractLineStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class CsvStream
extends AbstractLineStream {
    static Logger log = LoggerFactory.getLogger(CsvStream.class);
    final ArrayList<String> columns = new ArrayList();
    String[] keys;
    String splitExpression = "(;|,)";
    long lineNo = 0L;
    boolean header = true;

    public CsvStream(SourceURL url) throws Exception {
        super(url);
    }

    public CsvStream(InputStream in) throws Exception {
        super(in);
        this.splitExpression = "(;|,)";
        log.debug("Split expression is: {}", (Object)this.splitExpression);
    }

    public CsvStream(InputStream in, String splitter) throws Exception {
        this(in, Charset.defaultCharset(), splitter);
    }

    public CsvStream(InputStream in, Charset charset, String splitter) throws Exception {
        super(in);
        this.splitExpression = splitter;
        log.debug("Split expression is: {}", (Object)this.splitExpression);
    }

    public CsvStream(SourceURL url, String splitExp) throws Exception {
        super(url);
        this.url = url;
        this.splitExpression = splitExp;
    }

    public boolean isHeader() {
        return this.header;
    }

    @Parameter(description="Determines whether the first line should be used as header (column names), defaults to 'true'.", required=false)
    public void setHeader(boolean header) {
        this.header = header;
    }

    @Parameter(name="separator", required=true, defaultValue="(;|,)")
    public void setSeparator(String separator) {
        this.splitExpression = separator;
    }

    public String getSeparator() {
        return this.splitExpression;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    @Override
    public Data readNext() throws Exception {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (this.lineNo == 0L) {
            if (this.header) {
                String[] token = line.split(this.splitExpression);
                for (int i = 0; i < token.length; ++i) {
                    String col = token[i];
                    this.columns.add(col);
                }
                line = this.readLine();
            }
            if (this.keys != null) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (i < this.columns.size()) {
                        this.columns.set(i, this.keys[i]);
                        continue;
                    }
                    this.columns.add(this.keys[i]);
                }
            }
        }
        ++this.lineNo;
        if (line == null) {
            return null;
        }
        Data item = DataFactory.create();
        String[] tok = line.split(this.splitExpression);
        for (int i = 0; i < tok.length; ++i) {
            Object value;
            String key = i >= this.columns.size() ? "column:" + i : this.columns.get(i);
            try {
                value = new Double(this.removeQuotes(tok[i]));
            }
            catch (Exception e) {
                value = this.removeQuotes(tok[i]);
            }
            item.put(key, value);
        }
        return item;
    }

    @Override
    public String readLine() throws Exception {
        String line = this.reader.readLine();
        while (line != null && line.startsWith("#")) {
            line = this.reader.readLine();
        }
        return line;
    }

    protected String removeQuotes(String str) {
        if (str == null) {
            return str;
        }
        String s = str;
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

