/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.expressions.ExpressionResolver;
import stream.service.Service;

@Description(group="Data Stream.Output")
public class CsvWriter
extends ConditionedProcessor
implements Service {
    static Logger log = LoggerFactory.getLogger(CsvWriter.class);
    protected PrintStream p;
    protected String separator = ",";
    protected String lastHeader;
    protected boolean headerWritten;
    protected String filter;
    protected List<String> headers;
    protected boolean closed;
    protected String[] keys;
    protected String urlString;
    protected URL url;
    protected File file;
    protected String lastUrlString = null;

    public CsvWriter() {
    }

    public CsvWriter(URL url) throws Exception {
        this(new FileOutputStream(new File(url.toURI())));
        this.setUrl(url.toString());
    }

    public CsvWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public CsvWriter(OutputStream out) {
        this(out, ",");
    }

    public CsvWriter(OutputStream out, String separator) {
        this();
        this.p = new PrintStream(out);
        this.separator = separator;
    }

    public CsvWriter(File file, String separator) throws IOException {
        this(file);
        this.separator = separator;
    }

    @Parameter(required=true, description="The url to write to.")
    public void setUrl(String url) {
        this.urlString = url;
    }

    public String getUrl() {
        return this.urlString;
    }

    public void setAttributeFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getHeaderNames() {
        return this.headers;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Parameter(required=false, description="The separator to separate columns, usually ','", defaultValue=",")
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Parameter(required=false, description="The attributes to write out, leave blank to write out all attributes.")
    public void setKeys(String[] str) {
        if (str == null || str.length == 0) {
            this.keys = null;
        }
        this.keys = str;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.headers = new LinkedList<String>();
        this.closed = false;
        this.lastHeader = null;
        this.headerWritten = false;
        this.filter = ".*";
    }

    @Override
    public Data processMatchingData(Data datum) {
        String expandedUrlString = ExpressionResolver.expand(this.urlString, this.context, datum);
        if (expandedUrlString == null) {
            log.error("can't find the file! {}", (Object)this.urlString);
            return datum;
        }
        if (this.lastUrlString == null || !expandedUrlString.equals(this.lastUrlString)) {
            if (this.p != null) {
                this.p.flush();
                this.p.close();
            }
            boolean append = this.p == null;
            try {
                this.lastUrlString = expandedUrlString;
                this.url = new URL(expandedUrlString);
                this.file = new File(this.url.toURI());
                OutputStream out = this.file.getAbsolutePath().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.file, append)) : new FileOutputStream(this.file, append);
                this.p = new PrintStream(out);
                this.lastHeader = null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error("Failed to open file: {}", (Object)e.getMessage());
            }
        }
        if (this.closed) {
            log.error("DataStreamWriter is closed! Not writing any more data items!");
            return datum;
        }
        this.writeHeader(datum);
        this.write(datum);
        return datum;
    }

    public void writeHeader(Data datum) {
        String header = this.createHeader(datum);
        if (this.lastHeader != null && this.lastHeader.equals(header)) {
            return;
        }
        if (this.lastHeader == null || !this.lastHeader.equals(header)) {
            this.p.println(header);
            this.lastHeader = header;
            return;
        }
        if (!this.headerWritten || this.keys == null && datum.keySet().size() > this.headers.size()) {
            this.p.print("# ");
            Iterator<Object> it = datum.keySet().iterator();
            if (this.keys != null) {
                it = Arrays.asList(this.keys).iterator();
            }
            while (it.hasNext()) {
                String name = (String)it.next();
                this.headers.add(name);
                this.p.print(name);
                if (!it.hasNext()) continue;
                this.p.print(this.separator);
            }
            this.p.println();
            this.headerWritten = true;
        }
    }

    public void write(Data datum) {
        Iterator<Object> it = null;
        it = this.keys != null && this.keys.length != 0 ? Arrays.asList(this.keys).iterator() : datum.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String stringValue = "?";
            Serializable val = (Serializable)datum.get(name);
            stringValue = val != null ? val.toString().replaceAll("\\n", "\\\\n") : "null";
            this.p.print(stringValue);
            if (!it.hasNext()) continue;
            this.p.print(this.separator);
        }
        this.p.println();
    }

    protected String createHeader(Data item) {
        StringWriter s = new StringWriter();
        s.append("# ");
        Iterator<Object> it = null;
        it = this.keys != null ? Arrays.asList(this.keys).iterator() : item.keySet().iterator();
        while (it.hasNext()) {
            s.append((CharSequence)it.next());
            if (!it.hasNext()) continue;
            s.append(this.separator);
        }
        return s.toString();
    }

    @Override
    public void finish() throws Exception {
        if (this.p != null) {
            this.p.flush();
            this.p.close();
        }
        this.closed = true;
    }

    @Override
    public void reset() throws Exception {
        this.headers = new LinkedList<String>();
        this.closed = false;
        this.separator = ",";
        this.lastHeader = null;
        this.headerWritten = false;
    }
}

