/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class DirectoryStream
extends AbstractStream {
    Logger log = LoggerFactory.getLogger(DirectoryStream.class);
    private File dir;
    private String[] files;
    private String dirPath;
    private int counter;

    public DirectoryStream(SourceURL url) throws Exception {
        super(url);
    }

    @Override
    public void init() throws Exception {
        this.log.debug("Initializing directory stream with URL '{}'", (Object)this.url.toString());
        this.log.debug("   file path of URL is: {}", (Object)this.url.getFile());
        this.dir = new File(this.url.getFile());
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Directory not found");
        }
        this.dirPath = this.dir.getAbsolutePath();
        this.files = this.dir.list();
        this.counter = 0;
    }

    @Override
    public Data readNext() throws Exception {
        Data data = DataFactory.create();
        if (this.counter < this.files.length) {
            data.put("@url", new URL("file:" + this.dirPath + System.getProperty("file.separator") + this.files[this.counter]));
            data.put("@directory", this.dirPath);
            data.put("@filename", this.files[this.counter]);
            ++this.counter;
            return data;
        }
        return null;
    }
}

