/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.util.FileUtils;

public class FifoInputStream
extends InputStream {
    static Logger log = LoggerFactory.getLogger(FifoInputStream.class);
    final File fifo;
    InputStream pipe;

    public FifoInputStream(File pipe) throws Exception {
        this.fifo = FileUtils.mkfifo(pipe);
    }

    @Override
    public int available() throws IOException {
        if (this.pipe != null) {
            return this.pipe.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.pipe != null) {
            this.pipe.close();
        }
    }

    @Override
    public synchronized void mark(int arg0) {
        if (this.pipe != null) {
            this.pipe.mark(arg0);
        }
    }

    @Override
    public boolean markSupported() {
        if (this.pipe != null) {
            return this.pipe.markSupported();
        }
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.pipe != null) {
            this.pipe.reset();
        }
    }

    @Override
    public long skip(long arg0) throws IOException {
        if (this.pipe != null) {
            return this.pipe.skip(arg0);
        }
        return 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.pipe == null) {
            if (this.fifo == null) {
                throw new FileNotFoundException("No file specified!");
            }
            if (!this.fifo.exists() || this.fifo.isDirectory()) {
                log.error("The file denoted by '{}' does not exist or is a directory!", (Object)this.fifo);
                throw new FileNotFoundException("File " + this.fifo.getAbsolutePath() + " does not exist or is a directory!");
            }
            log.debug("Opening new file-based input-stream for FIFO {}", (Object)this.fifo);
            this.pipe = new FileInputStream(this.fifo);
            log.info("Pipe is: {}", (Object)this.pipe);
        }
        if (this.pipe != null) {
            int b = this.pipe.read();
            return b;
        }
        return -1;
    }
}

