/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.io.Serializable;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractLineStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class JSONStream
extends AbstractLineStream {
    static Logger log = LoggerFactory.getLogger(JSONStream.class);
    JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);

    public JSONStream(InputStream in) throws Exception {
        super(in);
    }

    public JSONStream(SourceURL url) throws Exception {
        super(url);
    }

    @Override
    public Data readNext() throws Exception {
        Data instance = DataFactory.create();
        String line = this.readLine();
        log.debug("line: {}", (Object)line);
        if (line == null) {
            return null;
        }
        log.debug("Parsing item from {}", (Object)line);
        JSONObject object = this.parser.parse(line, JSONObject.class);
        if (object != null) {
            for (String key : object.keySet()) {
                Object val = object.get(key);
                if (val == null) continue;
                if (val instanceof Serializable) {
                    instance.put(key, (Serializable)val);
                    continue;
                }
                instance.put(key, val.toString());
            }
        } else {
            log.debug("Failed to parse item, object = {}", (Object)object);
        }
        log.debug("returning instance: {}", (Object)instance);
        return instance;
    }
}

