/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.urls.Connection;
import stream.urls.FIFOConnection;
import stream.urls.SSLConnection;
import stream.urls.TcpConnection;
import stream.util.parser.Parser;
import stream.util.parser.ParserGenerator;

public final class SourceURL
implements Serializable {
    private static final long serialVersionUID = -7992522266824113404L;
    static Logger log = LoggerFactory.getLogger(SourceURL.class);
    static final Map<String, Class<? extends Connection>> urlProvider = new LinkedHashMap<String, Class<? extends Connection>>();
    static final String FILE_GRAMMAR = "%(protocol):%(path)";
    static final String JDBC_GRAMMAR = "jdbc:%(driver):%(target)/%(path)";
    static final String GRAMMAR = "%(protocol)://%(address)/%(path)";
    final URL url;
    final String urlString;
    final String protocol;
    final String host;
    final int port;
    final String path;
    final String username;
    final String password;
    final Map<String, String> parameters = new LinkedHashMap<String, String>();

    public SourceURL(URL url) {
        this.url = url;
        this.urlString = url.toString();
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.path = url.getPath();
        this.username = null;
        this.password = null;
    }

    public SourceURL(String urlString) throws Exception {
        this.url = null;
        this.urlString = urlString;
        if (urlString.toLowerCase().startsWith("file:") || urlString.toLowerCase().startsWith("classpath") || urlString.toLowerCase().startsWith("fifo")) {
            ParserGenerator gen = new ParserGenerator(FILE_GRAMMAR);
            Parser<Map<String, String>> parser = gen.newParser();
            Map<String, String> vals = parser.parse(urlString);
            this.protocol = vals.get("protocol");
            this.host = null;
            this.username = null;
            this.password = null;
            this.port = -1;
            this.path = vals.get("path");
        } else {
            String grammar = GRAMMAR;
            if (urlString.toLowerCase().startsWith("jdbc")) {
                grammar = JDBC_GRAMMAR;
            }
            ParserGenerator gen = new ParserGenerator(grammar);
            Parser<Map<String, String>> parser = gen.newParser();
            Map<String, String> vals = parser.parse(urlString);
            this.protocol = vals.get("protocol");
            String hostname = vals.get("address");
            int at = hostname.indexOf("@");
            if (at >= 0) {
                String auth = hostname.substring(0, at);
                String[] tok = auth.split(":", 2);
                if (tok.length > 1) {
                    this.username = tok[0];
                    this.password = tok[1];
                } else {
                    this.username = auth;
                    this.password = "";
                }
                hostname = hostname.substring(at + 1);
            } else {
                this.username = null;
                this.password = null;
            }
            int idx = hostname.indexOf(":");
            int port = 80;
            if (idx > 0) {
                this.host = hostname.substring(0, idx);
                port = Integer.parseInt(hostname.substring(idx + 1));
            } else {
                this.host = hostname;
                if ("http".equalsIgnoreCase(this.protocol)) {
                    port = 80;
                }
                if ("https".equalsIgnoreCase(this.protocol)) {
                    port = 443;
                }
            }
            this.port = port;
            this.path = vals.get("path");
        }
        if (this.path != null && this.path.indexOf("?") >= 0) {
            String qs = this.path.substring(this.path.indexOf("?") + 1);
            log.debug("Query string for URL is: {}", (Object)qs);
            for (String pv : qs.split("&")) {
                if (pv.indexOf("=") > 0) {
                    String[] kv = pv.split("=", 2);
                    this.parameters.put(kv[0], kv[1]);
                    continue;
                }
                this.parameters.put(pv, "1");
            }
            log.debug("Parameters are: {}", (Object)this.parameters);
        }
    }

    protected boolean isGzip() {
        if (this.urlString != null && this.urlString.toLowerCase().endsWith(".gz")) {
            return true;
        }
        return this.url != null && this.url.toString().toLowerCase().endsWith(".gz");
    }

    public InputStream openStream() throws IOException {
        InputStream inputStream = this.createStream();
        if (this.isGzip()) {
            log.debug("Wrapping stream {} in GZIPInputStream for URL {}", (Object)inputStream, (Object)this);
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    private InputStream createStream() throws IOException {
        if (this.url != null) {
            return this.url.openStream();
        }
        for (String proto : urlProvider.keySet()) {
            if (!proto.equalsIgnoreCase(this.protocol)) continue;
            Class<? extends Connection> clazz = urlProvider.get(proto);
            log.debug("Found url-provider '{}' for URL {}", (Object)clazz, (Object)this);
            try {
                Constructor<? extends Connection> constructor = clazz.getConstructor(SourceURL.class);
                log.debug("Using constructor {} to create new instance of provider {}", (Object)constructor, (Object)clazz);
                Connection con = constructor.newInstance(this);
                return con.connect();
            }
            catch (NoSuchMethodException nsm) {
                nsm.printStackTrace();
                log.error("Failed to create instance of class {} for URL\u00a0{}", (Object)clazz, (Object)this);
                throw new IOException(nsm.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        if ("stdin".equalsIgnoreCase(this.protocol)) {
            return System.in;
        }
        if ("classpath".equalsIgnoreCase(this.protocol)) {
            log.debug("Returning InputStream for classpath resource '{}'", (Object)this.getPath());
            return SourceURL.class.getResourceAsStream(this.getPath());
        }
        if ("tcp".equalsIgnoreCase(this.protocol)) {
            TcpConnection con = new TcpConnection(this);
            return con.getInputStream();
        }
        if ("ssl".equalsIgnoreCase(this.protocol)) {
            try {
                SSLConnection ssl = new SSLConnection(this);
                ssl.open();
                return ssl.getInputStream();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        String theUrl = this.urlString;
        try {
            if (theUrl.startsWith("fifo:")) {
                log.debug("Handling FIFO URL pattern...");
                theUrl = theUrl.replace("fifo:", "file:");
                File file = new File(theUrl.replace("file:", ""));
                if (!file.exists()) {
                    log.debug("Creating new fifo file '{}' with mkfifo", (Object)file);
                    Process p = Runtime.getRuntime().exec("mkfifo " + file.getAbsolutePath());
                    log.debug("Waiting for mkfifo to return...");
                    int ret = p.waitFor();
                    log.debug("mkfifo finished: {}", (Object)ret);
                } else {
                    log.debug("Using existing fifo-file '{}'", (Object)file);
                }
                if (!file.exists()) {
                    throw new IOException("Failed to create/acquire FIFO file '" + file.getAbsolutePath() + "'!");
                }
                log.debug("Returning FileInputStream for FIFO {}", (Object)file);
                FileInputStream fis = new FileInputStream(file);
                return fis;
            }
            log.debug("The URL string is: '{}'", (Object)theUrl);
            URL url = new URL(theUrl);
            return url.openStream();
        }
        catch (Exception e) {
            log.error("Failed to open '{}' with default Java URL mechanism: {}", (Object)theUrl, (Object)e.getMessage());
            throw new IOException("No handler found for protocol '" + this.protocol + "'!");
        }
    }

    public String getFile() {
        return this.path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    static {
        urlProvider.put("ssl", SSLConnection.class);
        urlProvider.put("tcp", TcpConnection.class);
        urlProvider.put("fifo", FIFOConnection.class);
    }
}

