/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.data.DataFactory;
import stream.io.Stream;
import stream.io.active.ActiveDataStream;
import stream.io.active.ActiveDataStreamImpl;
import stream.io.multi.MultiDataStream;

public abstract class AbstractMultiDataStream
implements MultiDataStream {
    static Logger log = LoggerFactory.getLogger(AbstractMultiDataStream.class);
    protected ArrayList<Processor> preprocessors;
    protected Map<String, Class<?>> attributes = new LinkedHashMap();
    protected Long limit = -1L;
    protected Long count = 0L;
    protected Boolean activate = false;
    protected Map<String, Stream> streams;
    protected List<String> additionOrder;
    protected ActiveDataStream activeWrapper;
    protected String id;

    public AbstractMultiDataStream() {
        this.preprocessors = new ArrayList();
        this.streams = new HashMap<String, Stream>();
        this.additionOrder = new ArrayList<String>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void addStream(String id, Stream stream) {
        this.streams.put(id, stream);
        this.additionOrder.add(id);
        log.info("added Stream {}", (Object)stream);
    }

    @Override
    public Map<String, Stream> getStreams() {
        return this.streams;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Boolean getActivate() {
        return this.activate;
    }

    public void setActivate(Boolean activate) {
        this.activate = activate;
    }

    public Map<String, Class<?>> getAttributes() {
        return this.attributes;
    }

    public List<Processor> getPreprocessors() {
        return this.preprocessors;
    }

    public void addPreprocessor(Processor proc) {
        this.preprocessors.add(proc);
    }

    public void addPreprocessor(int idx, Processor proc) {
        this.preprocessors.add(idx, proc);
    }

    public boolean removePreprocessor(Processor proc) {
        return this.preprocessors.remove(proc);
    }

    public Processor removePreprocessor(int idx) {
        return this.preprocessors.remove(idx);
    }

    protected abstract Data readNext(Data var1, Map<String, Stream> var2) throws Exception;

    @Override
    public Data read() throws Exception {
        return this.readNext(DataFactory.create());
    }

    public final Data readNext(Data item) throws Exception {
        if (this.limit > 0L && this.count >= this.limit) {
            return null;
        }
        Data datum = null;
        while (datum == null) {
            Processor proc;
            datum = this.readNext(item, this.streams);
            if (datum == null) {
                log.debug("End-of-stream reached!");
                return null;
            }
            Iterator<Processor> i$ = this.preprocessors.iterator();
            while (i$.hasNext() && (datum = (proc = i$.next()).process(datum)) != null) {
            }
        }
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        return datum;
    }

    @Override
    public void close() throws Exception {
        for (Stream s : this.streams.values()) {
            try {
                s.close();
            }
            catch (Exception e) {
                log.error("Failed to close stream {}: {}", (Object)s, (Object)e.getMessage());
            }
        }
    }

    @Override
    public void init() throws Exception {
        for (Stream s : this.streams.values()) {
            s.init();
        }
        log.info("initialized all Streams.");
        if (this.activate.booleanValue()) {
            this.activeWrapper = new ActiveDataStreamImpl(this);
            this.activeWrapper.activate();
            log.info("Activated this multiStream.");
        }
    }
}

