/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import java.util.Map;
import stream.Data;
import stream.io.Stream;
import stream.io.multi.AbstractMultiDataStream;

public class RandomMultiStream
extends AbstractMultiDataStream {
    Double[] weights;

    public Double[] getWeights() {
        return this.weights;
    }

    public void setWeights(Double[] weights) {
        this.weights = weights;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.weights == null) {
            log.warn("No weights specified, using unified distribution over all streams.");
            this.weights = new Double[this.additionOrder.size()];
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = 1.0 / (double)this.additionOrder.size();
            }
        } else {
            int i;
            double totalWeight = 0.0;
            for (i = 0; i < this.weights.length; ++i) {
                totalWeight += this.weights[i].doubleValue();
            }
            for (i = 0; i < this.weights.length; ++i) {
                this.weights[i] = this.weights[i] / totalWeight;
            }
        }
    }

    protected String selectNextStream() {
        double rnd = Math.random();
        double sum = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            if (rnd >= sum && rnd < sum + this.weights[i]) {
                return (String)this.additionOrder.get(i);
            }
            sum += this.weights[i].doubleValue();
        }
        return (String)this.additionOrder.get(this.additionOrder.size() - 1);
    }

    @Override
    protected Data readNext(Data item, Map<String, Stream> streams) throws Exception {
        String nextKey = this.selectNextStream();
        Stream stream = streams.get(nextKey);
        Data nextItem = stream.read();
        nextItem.put("@stream:id", nextKey);
        return nextItem;
    }
}

