/*
 * Decompiled with CFR 0.152.
 */
package stream.io.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;

public abstract class DatabaseDialect {
    static Logger log = LoggerFactory.getLogger(DatabaseDialect.class);
    public static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    protected final Map<Class<?>, String> columnTypeDefs = new HashMap();

    public DatabaseDialect() {
        this.setColumnType(Double.class, "REAL");
        this.setColumnType(Float.class, "REAL");
        this.setColumnType(Integer.class, "INTEGER");
        this.setColumnType(Long.class, "BIGINT");
        this.setColumnType(String.class, "VARCHAR(1024)");
        this.setColumnType(BYTE_ARRAY_CLASS, "BLOB");
    }

    protected void setColumnType(Class<?> clazz, String colDef) {
        log.debug("setting ColumnType for class {} to '{}'", (Object)clazz, (Object)colDef);
        this.columnTypeDefs.put(clazz, colDef);
    }

    public String getColumnType(Class<?> clazz) {
        if (this.columnTypeDefs.containsKey(clazz)) {
            String def = this.columnTypeDefs.get(clazz);
            log.debug("Found pre-defined column type definition '{}' for class {}", (Object)def, (Object)clazz);
            return def;
        }
        if (clazz == Double.class) {
            log.debug("Mapping class {} to column type 'REAL'", (Object)clazz);
            return "REAL";
        }
        if (clazz == Integer.class) {
            log.debug("Mapping class {} to column type 'INTEGER'", (Object)clazz);
            return "INTEGER";
        }
        if (clazz == Long.class) {
            log.debug("Mapping class {} to column type 'BIGINT'", (Object)clazz);
            return "BIGINT";
        }
        if (clazz.isArray() && clazz.getComponentType() == Byte.class) {
            log.debug("Mapping class array of {} to column type 'BLOB'", (Object)clazz.getComponentType());
            return "BLOB";
        }
        if (clazz == String.class) {
            log.debug("Mapping class {} to column type 'VARCHAR(255)'", (Object)clazz);
            return "VARCHAR(255)";
        }
        log.debug("Mapping class {} to default column type 'TEXT'", (Object)clazz);
        return "TEXT";
    }

    public Class<?> mapTypeToClass(int t) {
        switch (t) {
            case 3: 
            case 6: 
            case 8: {
                return Double.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -2: {
                return BYTE_ARRAY_CLASS;
            }
        }
        return String.class;
    }

    public String mapColumnName(String key) {
        if (key.startsWith("@")) {
            return "at_" + key.substring(1);
        }
        return key;
    }

    public String getCreatePrimaryKeySequence(String key) {
        return null;
    }

    public String getPrimaryKeyDefinition(String key) {
        return key;
    }

    public String getCreateTableCommand(String name, Map<String, Class<?>> types) {
        StringBuffer s = new StringBuffer();
        s.append("CREATE TABLE " + name + " (\n");
        Iterator<String> it = types.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String colName = this.mapColumnName(key);
            String colType = this.getColumnType(types.get(key));
            s.append(" ");
            s.append(colName);
            s.append(" ");
            s.append(colType);
            if (!it.hasNext()) continue;
            s.append(",\n");
        }
        s.append(" )\n");
        return s.toString();
    }

    public String unmapColumnName(String column) {
        if (column.startsWith("AT_")) {
            return "@" + column.substring(3).toLowerCase();
        }
        return column.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getTableSchema(Connection con, String table) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            LinkedHashMap types = new LinkedHashMap();
            stmt = con.createStatement();
            stmt.setMaxRows(1);
            rs = stmt.executeQuery("SELECT * FROM " + table);
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                String name = meta.getColumnName(i + 1);
                int type = meta.getColumnType(i + 1);
                Class<?> clazz = this.mapTypeToClass(type);
                name = this.unmapColumnName(name);
                log.info("Adding  {} => {}", (Object)name, (Object)clazz);
                types.put(name, clazz);
            }
            rs.close();
            stmt.close();
            LinkedHashMap i = types;
            return i;
        }
        catch (Exception e) {
            log.error("Failed to retrieve schema of table {}: {}", (Object)table, (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            Map<String, Class<?>> map = null;
            return map;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, Class<?>> getColumnTypes(Data item) {
        LinkedHashMap types = new LinkedHashMap();
        for (String key : item.keySet()) {
            log.info("Checking type of key {}", (Object)key);
            types.put(key, ((Serializable)item.get(key)).getClass());
        }
        return types;
    }
}

