/*
 * Decompiled with CFR 0.152.
 */
package stream.monitor;

import java.util.concurrent.atomic.AtomicLong;
import stream.Data;
import stream.Processor;
import stream.data.Statistics;
import stream.statistics.StatisticsService;

public class MemoryUsage
implements Processor,
StatisticsService {
    String key = "@jvm:memory";
    AtomicLong memoryUsed = new AtomicLong(0L);

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void reset() throws Exception {
        this.memoryUsed.set(0L);
    }

    @Override
    public Statistics getStatistics() {
        Statistics stats = new Statistics();
        stats.put(this.key, this.memoryUsed.doubleValue());
        return stats;
    }

    @Override
    public Data process(Data input) {
        Runtime rt = Runtime.getRuntime();
        Long usedMB = rt.totalMemory() - rt.freeMemory();
        this.memoryUsed.set(usedMB);
        input.put(this.key, usedMB);
        return input;
    }
}

