/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;

public class DataTap
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(DataTap.class);
    String address = "0.0.0.0";
    Integer port = 9100;
    boolean gzip = false;
    ServerThread server;

    public String getAddress() {
        return this.address;
    }

    @Parameter(description="The socket address to listen on, needs to be a local address, defaults to 0.0.0.0.")
    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    @Parameter(description="The port to listen on for incoming tap connections, defaults to 9100.")
    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    @Parameter(description="This parameter allows for enabling GZIP compression on the TCP stream, default is no compression.")
    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.server = new ServerThread(this.address, this.port, this.gzip);
        this.server.start();
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        this.server.shutdown();
    }

    @Override
    public Data process(Data input) {
        int clients = this.server.getNumberOfClients();
        if (clients > 0) {
            log.debug("Copying item to {} clients", (Object)clients);
            this.server.add(input);
        } else {
            log.debug("No clients connected, no tap for this item.");
        }
        return input;
    }

    public static final class ClientHandler
    extends Thread {
        static final Logger log = LoggerFactory.getLogger(ClientHandler.class);
        final Socket socket;
        final LinkedBlockingQueue<Data> chunks = new LinkedBlockingQueue();
        final ObjectOutputStream out;
        final ServerThread server;

        public ClientHandler(ServerThread server, Socket sock, boolean gzip) throws IOException {
            this.server = server;
            this.socket = sock;
            this.out = gzip ? new ObjectOutputStream(new GZIPOutputStream(sock.getOutputStream())) : new ObjectOutputStream(sock.getOutputStream());
        }

        @Override
        public void run() {
            boolean running = true;
            while (running && this.socket.isConnected()) {
                try {
                    Data chunk = this.chunks.take();
                    if (chunk == null) continue;
                    this.out.writeObject(chunk);
                    this.out.reset();
                }
                catch (SocketException se) {
                    log.error("Socket error: {}", (Object)se.getMessage());
                    log.debug("Disconnecting client...");
                    running = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.debug("Sending exit signal to server...");
            this.chunks.clear();
            this.server.clientExited(this);
        }

        public void add(Data chunk) {
            if (this.chunks.size() > 25) {
                log.debug("{} chunks pending in client queue for {}", (Object)this.socket);
            }
            this.chunks.add(chunk);
        }
    }

    public static final class ServerThread
    extends Thread {
        static Logger log = LoggerFactory.getLogger(ServerThread.class);
        boolean running = true;
        final ServerSocket server;
        final List<ClientHandler> clients = new ArrayList<ClientHandler>();
        final boolean gzip;

        public ServerThread(String address, int port, boolean gz) throws Exception {
            this.server = new ServerSocket(port);
            this.gzip = gz;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Starting TCP DataTap server on socket {}", (Object)this.server);
            try {
                while (this.running) {
                    try {
                        Socket socket = this.server.accept();
                        ClientHandler handler = new ClientHandler(this, socket, this.gzip);
                        log.info("New client connection accepted: {}", (Object)socket);
                        List<ClientHandler> list = this.clients;
                        synchronized (list) {
                            this.clients.add(handler);
                        }
                        handler.start();
                    }
                    catch (Exception e) {
                        log.error("Error: {}", (Object)e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    log.info("Closing TAP socket");
                    this.server.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void shutdown() {
            log.debug("Shutting down ServerThread");
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumberOfClients() {
            List<ClientHandler> list = this.clients;
            synchronized (list) {
                return this.clients.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Data item) {
            List<ClientHandler> list = this.clients;
            synchronized (list) {
                log.debug("Spreading data item to {} clients", (Object)this.clients.size());
                for (ClientHandler client : this.clients) {
                    client.add(item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientExited(ClientHandler client) {
            List<ClientHandler> list = this.clients;
            synchronized (list) {
                log.debug("Removed client {} from the list of clients.", (Object)client);
                this.clients.remove(client);
            }
        }
    }
}

