/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.io.PrintStream;
import java.net.Socket;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;

public class TcpSender
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(TcpSender.class);
    Socket socket = null;
    PrintStream out = null;
    String[] keys;
    String address;
    int port;

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
    }

    protected void connect() throws Exception {
        log.debug("Opening socket connection to {}:{}... ", (Object)this.address, (Object)this.port);
        try {
            this.socket = new Socket(this.address, this.port);
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (Exception e) {
            this.socket = null;
            throw e;
        }
    }

    @Override
    public Data process(Data input) {
        if (input == null) {
            return input;
        }
        try {
            if (this.socket == null) {
                this.connect();
            }
            log.debug("Sending item {}", (Object)input);
            String json = JSONObject.toJSONString(input);
            this.out.println(json);
        }
        catch (Exception e) {
            log.error("Faild to send item: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return input;
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

