/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(group="Streams.Processing.Transformations.Parsers", text="Creates n-grams from a specified string attribute and adds the frequencies of the resulting n-grams to the data item as (key,value) pairs.")
public class NGrams
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(NGrams.class);
    String key = null;
    String prefix = "";
    Integer n = 3;

    @Override
    public Data process(Data data) {
        log.debug("Processing key '{}' of item {}", (Object)this.key, (Object)data);
        if (this.key != null && this.n != null && this.n >= 0) {
            LinkedHashMap<String, Double> counts = new LinkedHashMap<String, Double>();
            Serializable val = (Serializable)data.get(this.key);
            if (val != null) {
                String str = val.toString();
                for (int i = 0; i < str.length() - this.n; ++i) {
                    String ngram = str.substring(i, i + this.n);
                    Double freq = (Double)counts.get(ngram);
                    freq = freq != null ? Double.valueOf(freq + 1.0) : Double.valueOf(1.0);
                    counts.put(ngram, freq);
                }
                for (String key : counts.keySet()) {
                    data.put(this.prefix + key, counts.get(key));
                }
                log.debug("Added {} {}-grams to item", (Object)counts.size(), (Object)this.n);
            }
        } else {
            log.warn("No key defined or parameter 'N' missing or smaller than 1!");
        }
        return data;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(required=true, description="The attribute which is to be split into n-grams")
    public void setKey(String key) {
        this.key = key;
    }

    public Integer getN() {
        return this.n;
    }

    @Parameter(required=true, defaultValue="3", description="The length of the n-grams that are to be created")
    public void setN(Integer n) {
        this.n = n;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Parameter(required=false, defaultValue="", description="An optional prefix that is to be prepended for all n-gram names before these are added to the data item")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

