/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import java.io.Serializable;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(group="Streams.Processing.Transformations.Parsers")
public class ParseJSON
implements Processor {
    static Logger log = LoggerFactory.getLogger(ParseJSON.class);
    String key = "@json";
    boolean remove = false;
    String prefix = null;

    public String getKey() {
        return this.key;
    }

    @Parameter(required=false, description="The attribute into which the JSON string of this item should be stored. Default is '@json'.")
    public void setKey(String key) {
        this.key = key;
    }

    public boolean isRemove() {
        return this.remove;
    }

    @Parameter(required=false, description="Set to 'true' if you want the attribute from which the JSON object has been parsed to be removed.")
    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Parameter(required=false, description="An optional prefix that will be prepended to the attributes/keys parsed from the JSON string.")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Data process(Data input) {
        block8: {
            JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            Serializable val = (Serializable)input.get(this.key);
            if (val == null) {
                return input;
            }
            String value = val.toString();
            try {
                JSONObject object = parser.parse(value, JSONObject.class);
                if (object == null) {
                    return input;
                }
                for (String key : object.keySet()) {
                    Object data = object.get(key);
                    if (data instanceof Serializable) {
                        if (this.prefix != null) {
                            input.put(this.prefix + key, (Serializable)data);
                            continue;
                        }
                        input.put(key, (Serializable)data);
                        continue;
                    }
                    log.warn("JSON object contains non-serializable object in property '{}': {}", (Object)key, data);
                }
                if (this.remove && !object.containsKey(this.key)) {
                    input.remove(this.key);
                }
            }
            catch (Exception e) {
                log.error("Failed to parse JSON object from key {}: {}", (Object)this.key, (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block8;
                e.printStackTrace();
            }
        }
        return input;
    }
}

