/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(group="Streams.Processing.Transformations.Parsers")
public class ParseTimestamp
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(ParseTimestamp.class);
    SimpleDateFormat dateFormat = null;
    String key = "@timestamp";
    String format = null;
    String from = null;
    String timezone = null;

    public ParseTimestamp() {
    }

    public ParseTimestamp(String key, String format, String from) {
        this.setKey(key);
        this.setFormat(format);
        this.setFrom(from);
    }

    public String getTimezone() {
        return this.timezone;
    }

    @Parameter(required=false, description="The timezone that the processed data is assumed to refer to.")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter
    public void setKey(String key) {
        this.key = key;
    }

    public String getFormat() {
        return this.format;
    }

    @Parameter(required=true, defaultValue="yyyy-MM-dd HH:mm:ss", description="The date format string used for parsing.")
    public void setFormat(String format) {
        this.format = format;
    }

    public String getFrom() {
        return this.from;
    }

    @Parameter(required=true, description="The key/attribute from which the timestamp should be parsed.")
    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public Data process(Data data) {
        if (data != null && this.key != null) {
            Serializable from = (Serializable)data.get(this.getFrom());
            if (this.dateFormat != null && from != null) {
                try {
                    Date date = this.dateFormat.parse(from.toString());
                    data.put(this.key, date.getTime());
                }
                catch (Exception e) {
                    log.error("Failed to parse timestamp from '{}', expected format is '{}'", (Object)from, (Object)this.format);
                }
            } else {
                data.put(this.key, new Long(System.currentTimeMillis()));
            }
        }
        return data;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.getFormat() != null && this.getFrom() != null) {
            this.dateFormat = new SimpleDateFormat(this.getFormat(), Locale.ENGLISH);
        }
        if (this.getTimezone() != null && this.getFrom() != null) {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone(this.getTimezone()));
        }
    }
}

