/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import stream.ProcessContext;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class LocalContext
implements ProcessContext {
    final Map<String, Service> lookupService = new HashMap<String, Service>();
    final Map<String, Object> context = new HashMap<String, Object>();

    public void register(String ref, Service p) throws Exception {
        this.lookupService.put(ref, p);
    }

    public void unregister(String ref) throws Exception {
        this.lookupService.remove(ref);
    }

    @Override
    public Object get(String key) {
        return this.context.get(key);
    }

    @Override
    public void set(String key, Object o) {
        this.context.put(key, o);
    }

    @Override
    public Object resolve(String variable) {
        return this.get(variable);
    }

    public Map<String, ServiceInfo> list() throws Exception {
        LinkedHashMap<String, ServiceInfo> classes = new LinkedHashMap<String, ServiceInfo>();
        for (String key : this.lookupService.keySet()) {
            classes.put(key, ServiceInfo.createServiceInfo(key, this.lookupService.get(key)));
        }
        return classes;
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        throw new Exception("Addition of remote naming services is not supported by local context!");
    }
}

