/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.ProcessContext;
import stream.runtime.ProcessListener;

public class ProcessThread
extends Thread {
    static Logger log = LoggerFactory.getLogger(ProcessThread.class);
    final Process process;
    final ProcessContext context;
    boolean running = false;
    protected final List<ProcessListener> processListener = new ArrayList<ProcessListener>();

    public ProcessThread(Process process, ProcessContext ctx) {
        this.process = process;
        this.context = ctx;
    }

    public void addListener(ProcessListener l) {
        this.processListener.add(l);
    }

    public void removeListener(ProcessListener l) {
        this.processListener.remove(l);
    }

    public boolean isRunning() {
        return this.running;
    }

    public Process getProcess() {
        return this.process;
    }

    public void init() throws Exception {
        log.debug("Initializing process with process-context...");
        this.process.init(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            log.debug("Starting process {}, notifying listeners {}", (Object)this.process, (Object)this.processListener);
            for (ProcessListener l : this.processListener) {
                log.debug("Calling process-listener {}", (Object)l);
                l.processStarted(this.process);
            }
            this.process.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.process.finish();
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
        finally {
            block16: {
                try {
                    log.debug("Process {} finished, notifying listeners: {}", (Object)this.process, (Object)this.processListener);
                    for (ProcessListener l : this.processListener) {
                        log.debug("   Calling listener {}", (Object)l);
                        l.processFinished(this.process);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to call process listeners: {}", (Object)e.getMessage());
                    if (!log.isDebugEnabled()) break block16;
                    e.printStackTrace();
                }
            }
            this.running = false;
        }
    }
}

