/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import stream.runtime.setup.UserSettings;

public class StreamRuntime {
    public static final UserSettings userSettings = new UserSettings();
    private static boolean loggingSetup = false;
    public static String[] logSearchPath = new String[]{"", userSettings.getStreamsDirectory().getAbsolutePath()};

    public static void setupLogging() {
        if (loggingSetup) {
            return;
        }
        loggingSetup = true;
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (System.getenv("STREAMS_HOME") != null) {
            searchPaths.add(System.getenv("STREAMS_HOME") + File.separator + "conf");
        }
        for (String path : logSearchPath) {
            searchPaths.add(path);
        }
        for (String path : searchPaths) {
            String p = path;
            p = !p.isEmpty() ? path + File.separator + "log4j.properties" : "log4j.properties";
            File logProp = new File(p);
            if (!logProp.canRead()) continue;
            System.err.println("Using log settings from " + logProp.getAbsolutePath());
            try {
                Class<?> configurator = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method configure = configurator.getMethod("configure", String.class);
                configure.invoke(null, logProp.getAbsolutePath());
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to setup logging with log4j.properties: " + e.getMessage());
            }
        }
    }
}

